/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00012\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a.\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"QUOTE_TO_KIND", "", "", "Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "countScores", "", "text", "findBestQuotationForEscaping", "Lkotlin/Pair;", "literalText", "fallbackKindForEscapedStrings", "mainStringKind", "intellij.groovy.psi"})
public final class EscapingKt {
    private static final Map<String, GrStringStyleViolationInspection.InspectionStringQuotationKind> QUOTE_TO_KIND = MapsKt.toMap((Iterable)CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"'", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED)), TuplesKt.to((Object)"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED)), TuplesKt.to((Object)"'''", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED)), TuplesKt.to((Object)"\"\"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED)), TuplesKt.to((Object)"/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY)), TuplesKt.to((Object)"$/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED))}));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Pair<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> findBestQuotationForEscaping(@NotNull String literalText, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind fallbackKindForEscapedStrings, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind mainStringKind) {
        Map.Entry bestEscaping2;
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        Intrinsics.checkNotNullParameter((Object)((Object)fallbackKindForEscapedStrings), (String)"fallbackKindForEscapedStrings");
        Intrinsics.checkNotNullParameter((Object)((Object)mainStringKind), (String)"mainStringKind");
        String startQuote = GrStringUtil.getStartQuote(literalText);
        String unescapedText = GrStringUtil.unescapeString(GrStringUtil.removeQuotes(literalText));
        GrStringStyleViolationInspection.InspectionStringQuotationKind inspectionStringQuotationKind = QUOTE_TO_KIND.get(startQuote);
        if (inspectionStringQuotationKind == null) return null;
        GrStringStyleViolationInspection.InspectionStringQuotationKind currentQuotation = inspectionStringQuotationKind;
        String string = unescapedText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapedText");
        Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> scores = EscapingKt.countScores(string);
        Integer n = scores.get((Object)currentQuotation);
        if (n == null) return null;
        int currentScore = n;
        Object object = scores;
        Comparator comparator2 = new Comparator(mainStringKind, currentQuotation, fallbackKindForEscapedStrings){
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $mainStringKind;
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $currentQuotation;
            final /* synthetic */ GrStringStyleViolationInspection.InspectionStringQuotationKind $fallbackKindForEscapedStrings;

            /*
             * WARNING - void declaration
             */
            public final int compare(Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> $dstr$leftKind$leftScore, Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> $dstr$rightKind$rightScore) {
                void rightKind;
                void leftKind;
                Object object = $dstr$leftKind$leftScore;
                GrStringStyleViolationInspection.InspectionStringQuotationKind inspectionStringQuotationKind = object.getKey();
                object = $dstr$leftKind$leftScore;
                int leftScore = ((Number)object.getValue()).intValue();
                Map.Entry<? extends GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> entry = $dstr$rightKind$rightScore;
                object = entry.getKey();
                entry = $dstr$rightKind$rightScore;
                int rightScore = ((Number)entry.getValue()).intValue();
                return leftScore == rightScore ? (leftKind == this.$mainStringKind ? -1 : (rightKind == this.$mainStringKind ? 1 : (leftKind == this.$currentQuotation ? -1 : (rightKind == this.$currentQuotation ? 1 : (leftKind == this.$fallbackKindForEscapedStrings ? -1 : (rightKind == this.$fallbackKindForEscapedStrings ? 1 : leftKind.toString().compareTo(rightKind.toString()))))))) : Intrinsics.compare((int)leftScore, (int)rightScore);
            }
            {
                this.$mainStringKind = inspectionStringQuotationKind;
                this.$currentQuotation = inspectionStringQuotationKind2;
                this.$fallbackKindForEscapedStrings = inspectionStringQuotationKind3;
            }
        };
        Map.Entry entry = bestEscaping2 = (Map.Entry)CollectionsKt.minWithOrNull((Iterable)object.entrySet(), (Comparator)comparator2);
        Map.Entry entry2 = entry;
        if (entry == null) return null;
        Object it = object = entry2;
        boolean bl = false;
        Pair pair = TuplesKt.to(it.getKey(), (Object)(currentScore - ((Number)it.getValue()).intValue()));
        entry2 = pair;
        if (pair == null) return null;
        it = object = entry2;
        boolean bl2 = false;
        if (((Number)it.getSecond()).intValue() < 0) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Object object2 = object;
        return object2;
    }

    private static final Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> countScores(String text) {
        int doubleQuotes = 0;
        int singleQuotes = 0;
        int dollars = 0;
        int doubleQuoteSequence = 0;
        int tripleQuotes = 0;
        int tripleDoubleQuotes = 0;
        int singleQuoteSequence = 0;
        int slashes = 0;
        int reversedSlashes = 0;
        String string = text;
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                ++doubleQuotes;
                ++doubleQuoteSequence;
            } else {
                tripleDoubleQuotes += doubleQuoteSequence / 3;
                doubleQuoteSequence = 0;
            }
            if (c == '\'') {
                ++singleQuotes;
                ++singleQuoteSequence;
            } else {
                tripleQuotes += singleQuoteSequence / 3;
                singleQuoteSequence = 0;
            }
            switch (c) {
                case '$': {
                    ++dollars;
                    continue block5;
                }
                case '/': {
                    ++slashes;
                    continue block5;
                }
                case '\\': {
                    ++reversedSlashes;
                }
            }
        }
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED), (Object)(doubleQuotes + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED), (Object)(singleQuotes + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED), (Object)(tripleQuotes * 3 + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED), (Object)(tripleDoubleQuotes * 3 + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED), (Object)dollars), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY), (Object)slashes)});
    }
}

