/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

public class BuildAndRestartConsoleAction
extends AnAction {
    private final Module myModule;
    private final Project myProject;
    private final Executor myExecutor;
    private final RunContentDescriptor myContentDescriptor;
    private final Consumer<? super Module> myRestarter;

    public BuildAndRestartConsoleAction(@NotNull Module module, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor contentDescriptor, @NotNull Consumer<? super Module> restarter) {
        if (module == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(2);
        }
        if (contentDescriptor == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(3);
        }
        if (restarter == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(4);
        }
        super(GroovyBundle.message("action.build.restart.text", new Object[0]), GroovyBundle.message("action.build.module.restart.description", module.getName()), AllIcons.Actions.Restart);
        this.myModule = module;
        this.myProject = project;
        this.myExecutor = executor;
        this.myContentDescriptor = contentDescriptor;
        this.myRestarter = restarter;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.myModule == null || this.myModule.isDisposed()) {
            return false;
        }
        ProcessHandler processHandler = this.myContentDescriptor.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BuildAndRestartConsoleAction.$$$reportNull$$$0(6);
        }
        if (RunContentManager.getInstance((Project)this.myProject).removeRunContent(this.myExecutor, this.myContentDescriptor)) {
            CompilerManager.getInstance((Project)this.myProject).compile(this.myModule, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!BuildAndRestartConsoleAction.this.myModule.isDisposed()) {
                        BuildAndRestartConsoleAction.this.myRestarter.consume((Object)BuildAndRestartConsoleAction.this.myModule);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction$1", "finished"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restarter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/console/BuildAndRestartConsoleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

