/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.closure.ForToEachPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ForToEachIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ForToEachPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        String bodyText;
        if (element == null) {
            ForToEachIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ForToEachIntention.$$$reportNull$$$0(1);
        }
        GrForStatement parentStatement = (GrForStatement)element;
        GrForInClause clause = (GrForInClause)parentStatement.getClause();
        GrVariable var = clause.getDeclaredVariable();
        GrStatement body = parentStatement.getBody();
        if (body instanceof GrBlockStatement) {
            String text = body.getText();
            bodyText = text.substring(1, text.length() - 1);
        } else {
            bodyText = body.getText();
        }
        GrExpression collection = clause.getIteratedExpression();
        assert (collection != null);
        @NonNls String statement = "x.each{" + var.getText() + " -> " + bodyText + " }";
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(parentStatement.getProject());
        GrMethodCallExpression eachExpression = (GrMethodCallExpression)factory.createTopElementFromText(statement);
        ((GrReferenceExpression)eachExpression.getInvokedExpression()).getQualifierExpression().replaceWithExpression(collection, true);
        parentStatement.replaceWithStatement(eachExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/closure/ForToEachIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

