/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

class ExpandBooleanPredicate
implements PsiElementPredicate {
    ExpandBooleanPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ExpandBooleanPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrStatement)) {
            return false;
        }
        GrStatement statement = (GrStatement)element;
        return ExpandBooleanPredicate.isBooleanReturn(statement) || ExpandBooleanPredicate.isBooleanAssignment(statement);
    }

    public static boolean isBooleanReturn(GrStatement statement) {
        if (!(statement instanceof GrReturnStatement)) {
            return false;
        }
        GrReturnStatement returnStatement = (GrReturnStatement)statement;
        GrExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        if (returnValue instanceof GrLiteral) {
            return false;
        }
        PsiType returnType2 = returnValue.getType();
        if (returnType2 == null) {
            return false;
        }
        return returnType2.equals(PsiType.BOOLEAN) || returnType2.equalsToText("java.lang.Boolean");
    }

    public static boolean isBooleanAssignment(GrStatement expression) {
        if (!(expression instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assignment = (GrAssignmentExpression)expression;
        GrExpression rhs = assignment.getRValue();
        if (rhs == null) {
            return false;
        }
        if (rhs instanceof GrLiteral) {
            return false;
        }
        PsiType assignmentType = rhs.getType();
        if (assignmentType == null) {
            return false;
        }
        return assignmentType.equals(PsiType.BOOLEAN) || assignmentType.equalsToText("java.lang.Boolean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/ExpandBooleanPredicate", "satisfiedBy"));
    }
}

