/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0019H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/impl/ConstructorProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lcom/intellij/psi/scope/NameHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "Lcom/intellij/psi/scope/ElementClassHint;", "name", "", "(Ljava/lang/String;)V", "candidates", "", "Lcom/intellij/psi/PsiMethod;", "getCandidates", "()Ljava/util/List;", "myCandidates", "Lcom/intellij/util/SmartList;", "execute", "", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "getName", "shouldProcess", "kind", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "intellij.groovy.psi"})
final class ConstructorProcessor
extends ProcessorWithHints
implements NameHint,
GroovyResolveKind.Hint,
ElementClassHint {
    private final SmartList<PsiMethod> myCandidates;
    private final String name;

    @NotNull
    public String getName(@NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.name;
    }

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return kind == GroovyResolveKind.METHOD;
    }

    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(element instanceof PsiMethod)) {
            if (Intrinsics.areEqual((Object)((Boolean)state.get(ResolveUtilKt.sorryCannotKnowElementKind)), (Object)true)) {
                return true;
            }
            String string = "Unexpected element. " + PsiUtilKt.elementInfo(element);
            throw new IllegalStateException(string.toString());
        }
        if (!((PsiMethod)element).isConstructor()) {
            return true;
        }
        Collection collection = (Collection)this.myCandidates;
        collection.add(element);
        return true;
    }

    @NotNull
    public final List<PsiMethod> getCandidates() {
        return (List)this.myCandidates;
    }

    public ConstructorProcessor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.hint(NameHint.KEY, this);
        this.hint(GroovyResolveKind.HINT_KEY, this);
        this.hint(ElementClassHint.KEY, this);
        this.myCandidates = new SmartList();
    }
}

