/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomRefIdConverter;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AntDomElement
implements DomElement {
    public static final Key<Role> ROLE = Key.create((String)"element_role");

    @Attribute(value="id")
    public abstract GenericAttributeValue<String> getId();

    @Attribute(value="refid")
    @Convert(value=AntDomRefIdConverter.class)
    public abstract GenericAttributeValue<AntDomElement> getRefId();

    public final AntDomProject getAntProject() {
        return (AntDomProject)this.getParentOfType(AntDomProject.class, false);
    }

    public final AntDomProject getContextAntProject() {
        AntConfigurationBase antConfig = AntConfigurationBase.getInstance(this.getManager().getProject());
        XmlElement xmlElement = this.getXmlElement();
        if (xmlElement == null) {
            return this.getAntProject();
        }
        PsiFile containingFile = xmlElement.getContainingFile();
        if (containingFile != null) {
            containingFile = containingFile.getOriginalFile();
        }
        if (!(containingFile instanceof XmlFile)) {
            return this.getAntProject();
        }
        XmlFile contextFile = antConfig.getEffectiveContextFile((XmlFile)containingFile);
        if (contextFile == null) {
            return this.getAntProject();
        }
        return AntSupport.getAntDomProject((PsiFile)contextFile);
    }

    public final Iterator<AntDomElement> getAntChildrenIterator() {
        List children = DomUtil.getDefinedChildren((DomElement)this, (boolean)true, (boolean)false);
        if (children.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator it = children.iterator();
        return new Iterator<AntDomElement>(){
            private DomElement myUnprocessedElement;

            @Override
            public boolean hasNext() {
                this.findNextAntElement();
                return this.myUnprocessedElement != null;
            }

            @Override
            public AntDomElement next() {
                this.findNextAntElement();
                if (this.myUnprocessedElement == null) {
                    throw new NoSuchElementException();
                }
                AntDomElement antElement = (AntDomElement)this.myUnprocessedElement;
                this.myUnprocessedElement = null;
                return antElement;
            }

            private void findNextAntElement() {
                if (this.myUnprocessedElement != null) {
                    return;
                }
                while (it.hasNext()) {
                    this.myUnprocessedElement = (DomElement)it.next();
                    if (!(this.myUnprocessedElement instanceof AntDomElement)) continue;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public final boolean isTask() {
        return Role.TASK == this.getChildDescription().getUserData(ROLE);
    }

    public final boolean isDataType() {
        return Role.DATA_TYPE == this.getChildDescription().getUserData(ROLE);
    }

    public String toString() {
        XmlTag tag = this.getXmlTag();
        if (tag == null) {
            return super.toString();
        }
        String name = tag.getName();
        if (name.isEmpty()) {
            return super.toString();
        }
        return name;
    }

    public static enum Role {
        TASK,
        DATA_TYPE;

    }
}

