/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;

public class DependencyTreePreorderIterator
implements Iterator {
    private Stack nodesToProcess = new Stack();

    public DependencyTreePreorderIterator(DependencyNode rootNode) {
        this.nodesToProcess.push(rootNode);
    }

    public boolean hasNext() {
        return !this.nodesToProcess.isEmpty();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DependencyNode currentNode = (DependencyNode)this.nodesToProcess.pop();
        List children = currentNode.getChildren();
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                this.nodesToProcess.push(children.get(i));
            }
        }
        return currentNode;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

