/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreviewState;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownEditorWithPreview
extends TextEditorWithPreview {
    public static final Key<MarkdownEditorWithPreview> PARENT_SPLIT_EDITOR_KEY = Key.create((String)"parentSplit");
    private boolean myAutoScrollPreview;
    private final List<SplitLayoutListener> myLayoutListeners;

    public MarkdownEditorWithPreview(@NotNull TextEditor editor2, @NotNull MarkdownPreviewFileEditor preview) {
        if (editor2 == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(1);
        }
        super(editor2, (FileEditor)preview, MarkdownBundle.message("markdown.editor.name", new Object[0]), TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, !MarkdownSettings.getInstance(ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject())).isVerticalSplit());
        this.myLayoutListeners = new ArrayList<SplitLayoutListener>();
        editor2.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.setMainEditor(editor2.getEditor());
        Project project = ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject());
        final MarkdownSettings settings = MarkdownSettings.getInstance(project);
        this.myAutoScrollPreview = settings.isAutoScrollEnabled();
        MarkdownSettings.ChangeListener settingsChangedListener = new MarkdownSettings.ChangeListener(){
            private boolean wasVerticalSplitBefore;
            {
                this.wasVerticalSplitBefore = settings.isVerticalSplit();
            }

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownSettings settings2) {
                if (settings2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.wasVerticalSplitBefore = settings2.isVerticalSplit();
            }

            @Override
            public void settingsChanged(@NotNull MarkdownSettings settings2) {
                if (settings2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                MarkdownEditorWithPreview.this.setAutoScrollPreview(settings2.isAutoScrollEnabled());
                if (this.wasVerticalSplitBefore != settings2.isVerticalSplit()) {
                    MarkdownEditorWithPreview.this.handleLayoutChange(!settings2.isVerticalSplit());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSettingsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "settingsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)settingsChangedListener);
        this.getTextEditor().getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener());
    }

    public void addLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.add(listener);
    }

    public void removeLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.remove(listener);
    }

    protected void onLayoutChange(TextEditorWithPreview.Layout oldValue, TextEditorWithPreview.Layout newValue) {
        this.myLayoutListeners.forEach(listener -> listener.onLayoutChange(oldValue, newValue));
        super.onLayoutChange(oldValue, newValue);
    }

    public boolean isAutoScrollPreview() {
        return this.myAutoScrollPreview;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.myAutoScrollPreview = autoScrollPreview;
    }

    public void setLayout(@NotNull TextEditorWithPreview.Layout layout) {
        if (layout == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(2);
        }
        super.setLayout(layout);
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(3);
        }
        if (state instanceof MarkdownEditorWithPreviewState) {
            MarkdownEditorWithPreviewState actualState = (MarkdownEditorWithPreviewState)state;
            super.setState(actualState.getUnderlyingState());
            this.setVerticalSplit(actualState.isVerticalSplit());
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(4);
        }
        FileEditorState underlyingState = super.getState(level);
        return new MarkdownEditorWithPreviewState(underlyingState, this.isVerticalSplit());
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        ToggleAction toggleAction = (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.EditorOnly"));
        if (toggleAction == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(5);
        }
        return toggleAction;
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        ToggleAction toggleAction = (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.EditorAndPreview"));
        if (toggleAction == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(6);
        }
        return toggleAction;
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        ToggleAction toggleAction = (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.PreviewOnly"));
        if (toggleAction == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(7);
        }
        return toggleAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowEditorAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowEditorAndPreviewAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowPreviewAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            int currentLine;
            if (event == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (!MarkdownEditorWithPreview.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int y = editor2.getScrollingModel().getVerticalScrollOffset();
            int n = currentLine = editor2 instanceof EditorImpl ? editor2.yToVisualLine(y) : y / editor2.getLineHeight();
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)MarkdownEditorWithPreview.this.getPreviewEditor()).scrollToSrcOffset(EditorUtil.getVisualLineEndOffset((Editor)editor2, (int)currentLine));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }

    public static interface SplitLayoutListener
    extends EventListener {
        public void onLayoutChange(TextEditorWithPreview.Layout var1, TextEditorWithPreview.Layout var2);
    }
}

