/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ranker.local;

import com.intellij.completion.ml.ranker.local.DecisionFunctionWithLanguages;
import com.intellij.completion.ml.ranker.local.LocalZipModelProvider;
import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsUtil;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REGISTRY_PATH_KEY", "", "executor", "Ljava/util/concurrent/ExecutorService;", "localModel", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$LocalModalInfo;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "languageId", "initModelFromPathToZipSynchronously", "", "isPathToTheModelChanged", "", "isPathToTheModelSet", "loadModel", "pathToZip", "scheduleInitModel", "Ljava/util/concurrent/Future;", "LocalModalInfo", "intellij.completionMlRanking"})
public final class MLCompletionLocalModelsUtil {
    private static final String REGISTRY_PATH_KEY = "completion.ml.path.to.zip.model";
    private static final Logger LOG;
    private static final ExecutorService executor;
    private static volatile LocalModalInfo localModel;
    @NotNull
    public static final MLCompletionLocalModelsUtil INSTANCE;

    @Nullable
    public final DecisionFunction getModel(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        if (!this.isPathToTheModelSet()) {
            localModel = null;
            return null;
        }
        if (this.isPathToTheModelChanged()) {
            this.scheduleInitModel();
            return null;
        }
        LocalModalInfo localModalInfo = localModel;
        if (localModalInfo == null) {
            return null;
        }
        LocalModalInfo resLocalModel = localModalInfo;
        Set<String> set = resLocalModel.getLanguages();
        String string = languageId;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        return set.contains(string2) ? resLocalModel.getDecisionFunction() : null;
    }

    private final Future<?> scheduleInitModel() {
        Future<?> future = executor.submit(scheduleInitModel.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit { initMo\u2026athToZipSynchronously() }");
        return future;
    }

    private final boolean isPathToTheModelSet() {
        RegistryValue registryValue = Registry.get((String)REGISTRY_PATH_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(REGISTRY_PATH_KEY)");
        return registryValue.isChangedFromDefault();
    }

    private final boolean isPathToTheModelChanged() {
        LocalModalInfo localModalInfo = localModel;
        return Intrinsics.areEqual((Object)Registry.stringValue((String)REGISTRY_PATH_KEY), (Object)(localModalInfo != null ? localModalInfo.getPath() : null)) ^ true;
    }

    private final void initModelFromPathToZipSynchronously() {
        localModel = null;
        long startTime = System.currentTimeMillis();
        String string = Registry.stringValue((String)REGISTRY_PATH_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Registry.stringValue(REGISTRY_PATH_KEY)");
        String pathToZip = string;
        localModel = this.loadModel(pathToZip);
        long endTime = System.currentTimeMillis();
        LOG.info("ML Completion local model initialization took: " + (endTime - startTime) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final LocalModalInfo loadModel(String pathToZip) {
        try {
            Closeable closeable = new ZipFile(pathToZip);
            Throwable throwable = null;
            try {
                void decisionFunction;
                LocalZipModelProvider localZipModelProvider;
                ZipFile file = (ZipFile)closeable;
                boolean bl = false;
                if (LocalZipModelProvider.Companion.findModelProvider$intellij_completionMlRanking(file) == null) {
                    LocalModalInfo localModalInfo = null;
                    return localModalInfo;
                }
                LocalZipModelProvider loader = localZipModelProvider;
                DecisionFunctionWithLanguages decisionFunctionWithLanguages = loader.loadModel(file);
                DecisionFunction decisionFunction2 = decisionFunctionWithLanguages.component1();
                List<String> languages = decisionFunctionWithLanguages.component2();
                LocalModalInfo localModalInfo = new LocalModalInfo((DecisionFunction)decisionFunction, pathToZip, CollectionsKt.toSet((Iterable)languages));
                return localModalInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            return null;
        }
    }

    private MLCompletionLocalModelsUtil() {
    }

    static {
        MLCompletionLocalModelsUtil mLCompletionLocalModelsUtil;
        INSTANCE = mLCompletionLocalModelsUtil = new MLCompletionLocalModelsUtil();
        Logger logger = Logger.getInstance(MLCompletionLocalModelsUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MLCom\u2026alModelsUtil::class.java)");
        LOG = logger;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"MLCompletionTxtModelsUtil pool executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026odelsUtil pool executor\")");
        executor = executorService;
    }

    public static final /* synthetic */ void access$initModelFromPathToZipSynchronously(MLCompletionLocalModelsUtil $this) {
        $this.initModelFromPathToZipSynchronously();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsUtil$LocalModalInfo;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "path", "", "languages", "", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/lang/String;Ljava/util/Set;)V", "getDecisionFunction", "()Lcom/intellij/internal/ml/DecisionFunction;", "getLanguages", "()Ljava/util/Set;", "getPath", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.completionMlRanking"})
    private static final class LocalModalInfo {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> languages;

        @NotNull
        public final DecisionFunction getDecisionFunction() {
            return this.decisionFunction;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getLanguages() {
            return this.languages;
        }

        public LocalModalInfo(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            this.decisionFunction = decisionFunction;
            this.path = path;
            this.languages = languages;
        }

        @NotNull
        public final DecisionFunction component1() {
            return this.decisionFunction;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final Set<String> component3() {
            return this.languages;
        }

        @NotNull
        public final LocalModalInfo copy(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            return new LocalModalInfo(decisionFunction, path, languages);
        }

        public static /* synthetic */ LocalModalInfo copy$default(LocalModalInfo localModalInfo, DecisionFunction decisionFunction, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                decisionFunction = localModalInfo.decisionFunction;
            }
            if ((n & 2) != 0) {
                string = localModalInfo.path;
            }
            if ((n & 4) != 0) {
                set = localModalInfo.languages;
            }
            return localModalInfo.copy(decisionFunction, string, set);
        }

        @NotNull
        public String toString() {
            return "LocalModalInfo(decisionFunction=" + this.decisionFunction + ", path=" + this.path + ", languages=" + this.languages + ")";
        }

        public int hashCode() {
            DecisionFunction decisionFunction = this.decisionFunction;
            String string = this.path;
            Set<String> set = this.languages;
            return ((decisionFunction != null ? decisionFunction.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LocalModalInfo)) break block3;
                    LocalModalInfo localModalInfo = (LocalModalInfo)object;
                    if (!Intrinsics.areEqual((Object)this.decisionFunction, (Object)localModalInfo.decisionFunction) || !Intrinsics.areEqual((Object)this.path, (Object)localModalInfo.path) || !Intrinsics.areEqual(this.languages, localModalInfo.languages)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

