/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.utils.resources;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.utils.TextKt;
import com.intellij.grazie.detector.utils.resources.JVMResourceLoader$WhenMappings;
import com.intellij.grazie.detector.utils.resources.ResourceLoader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/detector/utils/resources/JVMResourceLoader;", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "()V", "file", "", "type", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader$Type;", "language", "Lcom/intellij/grazie/detector/model/Language;", "path", "nlp-detector"})
public final class JVMResourceLoader
implements ResourceLoader {
    @NotNull
    public static final JVMResourceLoader INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String file(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = JVMResourceLoader.class.getClassLoader().getResourceAsStream(path);
        Intrinsics.checkNotNull((Object)inputStream);
        Closeable closeable = inputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @Override
    @NotNull
    public String file(@NotNull ResourceLoader.Type type, @NotNull Language language) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        switch (JVMResourceLoader$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string = this.file("lists/" + TextKt.toInvariantLowerCase(language.getIso().name()));
                break;
            }
            case 2: {
                string = this.file("ngrams/" + TextKt.toInvariantLowerCase(language.getIso().name()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private JVMResourceLoader() {
    }

    static {
        JVMResourceLoader jVMResourceLoader;
        INSTANCE = jVMResourceLoader = new JVMResourceLoader();
    }
}

