/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance DEFAULT_INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public static LevenshteinDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static int limitedCompare(CharSequence left, CharSequence right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = left.length();
        int m = right.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n = m;
            m = right.length();
        }
        if (m - n > threshold) {
            return -1;
        }
        int[] p2 = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p2[i2] = i2;
        }
        Arrays.fill(p2, boundary, p2.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char rightJ = right.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i3 = min; i3 <= max; ++i3) {
                d[i3] = left.charAt(i3 - 1) == rightJ ? p2[i3 - 1] : 1 + Math.min(Math.min(d[i3 - 1], p2[i3]), p2[i3 - 1]);
            }
            int[] tempD = p2;
            p2 = d;
            d = tempD;
        }
        if (p2[n] <= threshold) {
            return p2[n];
        }
        return -1;
    }

    private static int unlimitedCompare(CharSequence left, CharSequence right) {
        int i2;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n = left.length();
        int m = right.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n = m;
            m = right.length();
        }
        int[] p2 = new int[n + 1];
        for (i2 = 0; i2 <= n; ++i2) {
            p2[i2] = i2;
        }
        for (int j = 1; j <= m; ++j) {
            int upperLeft = p2[0];
            char rightJ = right.charAt(j - 1);
            p2[0] = j;
            for (i2 = 1; i2 <= n; ++i2) {
                int upper = p2[i2];
                int cost = left.charAt(i2 - 1) == rightJ ? 0 : 1;
                p2[i2] = Math.min(Math.min(p2[i2 - 1] + 1, p2[i2] + 1), upperLeft + cost);
                upperLeft = upper;
            }
        }
        return p2[n];
    }
}

