/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinFoldingBuilder;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtFunctionElementType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J.\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\"\u001a\u00020\u0006*\u00020\u0006H\u0002J\u0014\u0010#\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectionFactoryFunctionsNames", "", "", "appendDescriptors", "", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "quick", "", "getCommentContents", "line", "getFirstLineOfComment", "getLanguagePlaceholderText", "range", "Lcom/intellij/openapi/util/TextRange;", "getRangeToFold", "getTrimmedFirstLineOfString", "isCustomFoldingRoot", "isFirstElementInFile", "element", "isRegionCollapsedByDefault", "needFolding", "addSpaceIfNeeded", "shouldFoldCollection", "kotlin.idea"})
public final class KotlinFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private final Set<String> collectionFactoryFunctionsNames = SetsKt.setOf((Object[])new String[]{"arrayOf", "booleanArrayOf", "byteArrayOf", "charArrayOf", "doubleArrayOf", "floatArrayOf", "intArrayOf", "longArrayOf", "shortArrayOf", "arrayListOf", "hashMapOf", "hashSetOf", "linkedMapOf", "linkedSetOf", "linkedStringMapOf", "linkedStringSetOf", "listOf", "listOfNotNull", "mapOf", "mutableListOf", "mutableMapOf", "mutableSetOf", "setOf", "sortedMapOf", "sortedSetOf", "stringMapOf", "stringSetOf"});

    /*
     * WARNING - void declaration
     */
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors2, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof KtFile)) {
            return;
        }
        KtImportList importList = ((KtFile)root).getImportList();
        if (importList != null) {
            List list2 = importList.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"importList.imports");
            KtImportDirective firstImport = (KtImportDirective)CollectionsKt.firstOrNull((List)list2);
            if (firstImport != null && importList.getImports().size() > 1) {
                void $this$apply;
                FoldingDescriptor foldingDescriptor;
                PsiElement importKeyword;
                PsiElement psiElement2 = importKeyword = firstImport.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"importKeyword");
                int startOffset = PsiUtilsKt.getEndOffset((PsiElement)psiElement2) + 1;
                int endOffset2 = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
                FoldingDescriptor foldingDescriptor2 = foldingDescriptor = new FoldingDescriptor((PsiElement)importList, new TextRange(startOffset, endOffset2));
                List<FoldingDescriptor> list3 = descriptors2;
                boolean bl = false;
                $this$apply.setCanBeRemovedWhenCollapsed(true);
                Unit unit = Unit.INSTANCE;
                list3.add(foldingDescriptor);
            }
        }
        FileASTNode fileASTNode = ((KtFile)root).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"root.node");
        this.appendDescriptors((ASTNode)fileASTNode, document, descriptors2);
    }

    private final void appendDescriptors(ASTNode node2, Document document, List<FoldingDescriptor> descriptors2) {
        if (this.needFolding(node2, document)) {
            TextRange textRange = this.getRangeToFold(node2, document);
            TextRange textRange2 = node2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"node.textRange");
            TextRange textRange3 = textRange.shiftRight(-textRange2.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"textRange.shiftRight(-node.textRange.startOffset)");
            TextRange relativeRange = textRange3;
            CharSequence foldRegionText = node2.getChars().subSequence(relativeRange.getStartOffset(), relativeRange.getEndOffset());
            if (StringUtil.countNewLines((CharSequence)foldRegionText) > 0) {
                descriptors2.add(new FoldingDescriptor(node2, textRange));
            }
        }
        for (ASTNode child = node2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, document, descriptors2);
        }
    }

    private final boolean needFolding(ASTNode node2, Document document) {
        IElementType parentType;
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType type2 = iElementType;
        ASTNode aSTNode = node2.getTreeParent();
        Object object = parentType = aSTNode != null ? aSTNode.getElementType() : null;
        if (type2 instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            PsiElement psiElement2 = node2.getPsi();
            if (!(psiElement2 instanceof KtNamedFunction)) {
                psiElement2 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
            Object object2 = bodyExpression = ktNamedFunction != null ? ktNamedFunction.getBodyExpression() : null;
            if (bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                return true;
            }
        }
        return Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.FUNCTION_LITERAL) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.BLOCK) && Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.FUNCTION_LITERAL) ^ true || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)type2, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.STRING_TEMPLATE) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.WHEN) || this.shouldFoldCollection(node2, document);
    }

    private final boolean shouldFoldCollection(ASTNode $this$shouldFoldCollection, Document document) {
        boolean bl;
        block9: {
            PsiElement psiElement2 = $this$shouldFoldCollection.getPsi();
            if (!(psiElement2 instanceof KtCallExpression)) {
                psiElement2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call = ktCallExpression;
            if (DumbService.isDumb((Project)call.getProject())) {
                return false;
            }
            if (call.getValueArguments().size() < 2) {
                return false;
            }
            if (FixersUtilKt.startLine((PsiElement)call, document) == FixersUtilKt.endLine((PsiElement)call, document)) {
                return false;
            }
            KtReferenceExpression ktReferenceExpression = KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)call));
            if (ktReferenceExpression == null) {
                return false;
            }
            KtReferenceExpression reference2 = ktReferenceExpression;
            Iterable $this$any$iv = ReferenceUtilsKt.getMainReference((KtReferenceExpression)reference2).getResolvesByNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Name name2 = (Name)element$iv;
                    boolean bl2 = false;
                    if (!(name2.isSpecial() || !this.collectionFactoryFunctionsNames.contains(name2.getIdentifier()))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final TextRange getRangeToFold(ASTNode node2, Document document) {
        if (node2.getElementType() instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            KtNamedFunction function2;
            PsiElement psiElement2 = node2.getPsi();
            if (!(psiElement2 instanceof KtNamedFunction)) {
                psiElement2 = null;
            }
            KtNamedFunction ktNamedFunction = function2 = (KtNamedFunction)psiElement2;
            PsiElement funKeyword = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
            KtNamedFunction ktNamedFunction2 = function2;
            Object object = bodyExpression = ktNamedFunction2 != null ? ktNamedFunction2.getBodyExpression() : null;
            if (funKeyword != null && bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                if (FixersUtilKt.startLine(funKeyword, document) != FixersUtilKt.startLine((PsiElement)bodyExpression, document)) {
                    Object v5;
                    block15: {
                        Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)bodyExpression), (boolean)false, (boolean)false);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) continue;
                            v5 = element$iv;
                            break block15;
                        }
                        v5 = null;
                    }
                    PsiElement lineBreak = v5;
                    if (lineBreak != null) {
                        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lineBreak), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)bodyExpression)));
                    }
                }
                TextRange textRange = bodyExpression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"bodyExpression.textRange");
                return textRange;
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.FUNCTION_LITERAL)) {
            PsiElement rbrace;
            KtFunctionLiteral psi2;
            PsiElement psiElement3 = node2.getPsi();
            if (!(psiElement3 instanceof KtFunctionLiteral)) {
                psiElement3 = null;
            }
            KtFunctionLiteral ktFunctionLiteral = psi2 = (KtFunctionLiteral)psiElement3;
            PsiElement lbrace = ktFunctionLiteral != null ? ktFunctionLiteral.getLBrace() : null;
            KtFunctionLiteral ktFunctionLiteral2 = psi2;
            Object object = rbrace = ktFunctionLiteral2 != null ? ktFunctionLiteral2.getRBrace() : null;
            if (lbrace != null && rbrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lbrace), PsiUtilsKt.getEndOffset((PsiElement)rbrace));
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION)) {
            PsiElement rightParenthesis;
            KtValueArgumentList valueArgumentList2;
            PsiElement psiElement4 = node2.getPsi();
            if (!(psiElement4 instanceof KtCallExpression)) {
                psiElement4 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement4;
            KtValueArgumentList ktValueArgumentList = valueArgumentList2 = ktCallExpression != null ? ktCallExpression.getValueArgumentList() : null;
            PsiElement leftParenthesis = ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null;
            KtValueArgumentList ktValueArgumentList2 = valueArgumentList2;
            Object object = rightParenthesis = ktValueArgumentList2 != null ? ktValueArgumentList2.getRightParenthesis() : null;
            if (leftParenthesis != null && rightParenthesis != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)leftParenthesis), PsiUtilsKt.getEndOffset((PsiElement)rightParenthesis));
            }
        }
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.WHEN)) {
            PsiElement closeBrace;
            KtWhenExpression whenExpression2;
            PsiElement psiElement5 = node2.getPsi();
            if (!(psiElement5 instanceof KtWhenExpression)) {
                psiElement5 = null;
            }
            KtWhenExpression ktWhenExpression = whenExpression2 = (KtWhenExpression)psiElement5;
            PsiElement openBrace = ktWhenExpression != null ? ktWhenExpression.getOpenBrace() : null;
            KtWhenExpression ktWhenExpression2 = whenExpression2;
            Object object = closeBrace = ktWhenExpression2 != null ? ktWhenExpression2.getCloseBrace() : null;
            if (openBrace != null && closeBrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)openBrace), PsiUtilsKt.getEndOffset((PsiElement)closeBrace));
            }
        }
        TextRange textRange = node2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"node.textRange");
        return textRange;
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node2, @NotNull TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        return Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtTokens.BLOCK_COMMENT) ? "/" + this.getFirstLineOfComment(node2) + ".../" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KDocTokens.KDOC) ? "/**" + this.getFirstLineOfComment(node2) + "...*/" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.STRING_TEMPLATE) ? "\"\"\"" + this.addSpaceIfNeeded(this.getTrimmedFirstLineOfString(node2)) + "...\"\"\"" : (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION) ? "(...)" : (node2.getPsi() instanceof KtImportList ? "..." : "{...}"))));
    }

    private final String getTrimmedFirstLineOfString(ASTNode node2) {
        String firstLine2;
        String string;
        Object v1;
        block2: {
            String string2 = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.text");
            List lines = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), (Function1)getTrimmedFirstLineOfString.firstLine.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String p1 = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = p1;
                if (!(charSequence.length() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((string = (firstLine2 = (String)v1)) == null) {
            string = "";
        }
        return string;
    }

    private final String addSpaceIfNeeded(String $this$addSpaceIfNeeded) {
        CharSequence charSequence = $this$addSpaceIfNeeded;
        if (charSequence.length() == 0 || StringsKt.endsWith$default((String)$this$addSpaceIfNeeded, (String)" ", (boolean)false, (int)2, null)) {
            return $this$addSpaceIfNeeded;
        }
        return $this$addSpaceIfNeeded + " ";
    }

    private final String getFirstLineOfComment(ASTNode node2) {
        Object v1;
        block2: {
            String string = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            Iterable $this$firstOrNull$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = this.getCommentContents(it);
                if (!(charSequence.length() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) {
            return "";
        }
        String targetCommentLine = string;
        return " " + this.getCommentContents(targetCommentLine) + " ";
    }

    private final String getCommentContents(String line) {
        String string = line;
        string = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"/**"), (CharSequence)"/*"), (CharSequence)"*/"), (CharSequence)"*");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        JavaCodeFoldingSettings settings2 = JavaCodeFoldingSettings.getInstance();
        if (node2.getPsi() instanceof KtImportList) {
            JavaCodeFoldingSettings javaCodeFoldingSettings = settings2;
            Intrinsics.checkNotNullExpressionValue((Object)javaCodeFoldingSettings, (String)"settings");
            return javaCodeFoldingSettings.isCollapseImports();
        }
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType type2 = iElementType;
        if (Intrinsics.areEqual((Object)type2, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC)) {
            PsiElement psiElement2 = node2.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"node.psi");
            if (this.isFirstElementInFile(psiElement2)) {
                JavaCodeFoldingSettings javaCodeFoldingSettings = settings2;
                Intrinsics.checkNotNullExpressionValue((Object)javaCodeFoldingSettings, (String)"settings");
                return javaCodeFoldingSettings.isCollapseFileHeader();
            }
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.CLASS_BODY);
    }

    private final boolean isFirstElementInFile(PsiElement element3) {
        PsiElement parent2 = element3.getParent();
        if (parent2 instanceof KtFile) {
            Object v0;
            block2: {
                Sequence $this$firstOrNull$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)parent2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it.getTextLength() != 0 && !(it instanceof PsiWhiteSpace))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PsiElement firstNonWhiteSpace = v0;
            return Intrinsics.areEqual((Object)element3, (Object)firstNonWhiteSpace);
        }
        return false;
    }
}

