/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.caches.resolve.PlatformAnalysisSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.CompositeAnalysisSettings;
import org.jetbrains.kotlin.idea.caches.resolve.PlatformAnalysisSettingsImpl;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProvider;
import org.jetbrains.kotlin.idea.project.KotlinMultiplatformAnalysisModeComponentKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "getSdk", "(Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;)Lcom/intellij/openapi/projectRoots/Sdk;", "createPlatformAnalysisSettings", "Lorg/jetbrains/kotlin/caches/resolve/PlatformAnalysisSettings;", "project", "Lcom/intellij/openapi/project/Project;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "isAdditionalBuiltInFeaturesSupported", "", "supportsAdditionalBuiltInsMembers", "kotlin.core"})
public final class KotlinCacheServiceImplKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final PlatformAnalysisSettings createPlatformAnalysisSettings(@NotNull Project project2, @NotNull TargetPlatform platform2, @Nullable Sdk sdk2, boolean isAdditionalBuiltInFeaturesSupported) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        return KotlinMultiplatformAnalysisModeComponentKt.getUseCompositeAnalysis(project2) ? (PlatformAnalysisSettings)CompositeAnalysisSettings.INSTANCE : (PlatformAnalysisSettings)new PlatformAnalysisSettingsImpl(platform2, sdk2, isAdditionalBuiltInFeaturesSupported);
    }

    public static final boolean supportsAdditionalBuiltInsMembers(@NotNull IdeaModuleInfo $this$supportsAdditionalBuiltInsMembers, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsAdditionalBuiltInsMembers, (String)"$this$supportsAdditionalBuiltInsMembers");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return IDELanguageSettingsProvider.INSTANCE.getLanguageVersionSettings($this$supportsAdditionalBuiltInsMembers, project2).supportsFeature(LanguageFeature.AdditionalBuiltInsMembers);
    }

    @Nullable
    public static final Sdk getSdk(@NotNull IdeaModuleInfo $this$sdk) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$sdk, (String)"$this$sdk");
            Iterable $this$firstIsInstanceOrNull$iv = $this$sdk.dependencies();
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof SdkInfo)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        SdkInfo sdkInfo = v0;
        return sdkInfo != null ? sdkInfo.getSdk() : null;
    }

    static {
        Logger logger = Logger.getInstance(KotlinCacheService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(KotlinCacheService::class.java)");
        LOG = logger;
    }
}

