/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentEditor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentEditor;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "expressionWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "addWrapper", "wrapper", "editCodeFragment", "", "extractExpressionWithText", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "replaceExpression", "", "expression", "newExpressionText", "Companion", "kotlin.jvm-debugger.evaluation"})
public final class KotlinCodeFragmentEditor {
    private final List<KotlinExpressionWrapper> expressionWrappers;
    @NotNull
    private final KtCodeFragment codeFragment;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final KotlinCodeFragmentEditor addWrapper(@NotNull KotlinExpressionWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.expressionWrappers.add(wrapper);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean editCodeFragment() {
        void expression2;
        Pair<KtExpression, String> pair = this.extractExpressionWithText();
        if (pair == null) {
            return false;
        }
        Pair<KtExpression, String> pair2 = pair;
        KtExpression ktExpression = (KtExpression)pair2.component1();
        String expressionText2 = (String)pair2.component2();
        boolean expressionWasWrapped = false;
        String newExpressionText = expressionText2;
        for (KotlinExpressionWrapper wrapper : this.expressionWrappers) {
            if (!wrapper.isApplicable((KtExpression)expression2)) continue;
            expressionWasWrapped = true;
            newExpressionText = wrapper.createWrappedExpressionText(newExpressionText);
        }
        if (expressionWasWrapped) {
            this.replaceExpression((KtExpression)expression2, newExpressionText);
        }
        return expressionWasWrapped;
    }

    private final void replaceExpression(KtExpression expression2, String newExpressionText) {
        KtExpression newExpression2 = (KtExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtExpression>(expression2, newExpressionText){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ String $newExpressionText;

            @NotNull
            public final KtExpression invoke() {
                Project project2 = this.$expression.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"expression.project");
                return new KtPsiFactory(project2, false, 2, null).createExpression(this.$newExpressionText);
            }
            {
                this.$expression = ktExpression;
                this.$newExpressionText = string;
                super(0);
            }
        });
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(expression2, newExpression2){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KtExpression $newExpression;

            public final void invoke() {
                Project project2 = this.$expression.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"expression.project");
                ApplicationUtilsKt.executeWriteCommand(project2, KotlinDebuggerEvaluationBundle.message("wrap.expression", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ replaceExpression.1 this$0;

                    public final void invoke() {
                        this.this$0.$expression.replace((PsiElement)this.this$0.$newExpression);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$expression = ktExpression;
                this.$newExpression = ktExpression2;
                super(0);
            }
        }), (int)1, null);
    }

    private final Pair<KtExpression, String> extractExpressionWithText() {
        return (Pair)ApplicationUtilsKt.runReadAction((Function0)new Function0<Pair<? extends KtExpression, ? extends String>>(this){
            final /* synthetic */ KotlinCodeFragmentEditor this$0;

            @Nullable
            public final Pair<KtExpression, String> invoke() {
                KtExpression ktExpression;
                KtCodeFragment ktCodeFragment = this.this$0.getCodeFragment();
                if (ktCodeFragment instanceof KtExpressionCodeFragment) {
                    ktExpression = ((KtExpressionCodeFragment)this.this$0.getCodeFragment()).getContentElement();
                } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
                    List list2 = ((KtBlockCodeFragment)this.this$0.getCodeFragment()).getContentElement().getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"codeFragment.getContentElement().statements");
                    ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list2);
                } else {
                    KotlinCodeFragmentEditor.access$getLOG$cp().error("Invalid code fragment type: " + this.this$0.getClass());
                    ktExpression = null;
                }
                KtExpression expression2 = ktExpression;
                return expression2 == null ? null : new Pair((Object)expression2, (Object)expression2.getText());
            }
            {
                this.this$0 = kotlinCodeFragmentEditor;
                super(0);
            }
        });
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    public KotlinCodeFragmentEditor(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.expressionWrappers = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinCodeFragmentEditor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026agmentEditor::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentEditor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

