/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.KotlinImportOrderLayoutPanel;
import org.jetbrains.kotlin.idea.formatter.KotlinStarImportLayoutPanel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ImportSettingsPanel;", "Ljavax/swing/JPanel;", "()V", "cbImportNestedClasses", "Ljavax/swing/JCheckBox;", "importOrderLayoutPanel", "Lorg/jetbrains/kotlin/idea/formatter/KotlinImportOrderLayoutPanel;", "nameCountToUseStarImportForMembersSelector", "Lorg/jetbrains/kotlin/idea/formatter/ImportSettingsPanel$NameCountToUseStarImportSelector;", "nameCountToUseStarImportSelector", "starImportLayoutPanel", "Lorg/jetbrains/kotlin/idea/formatter/KotlinStarImportLayoutPanel;", "apply", "", "settings", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "isModified", "", "reset", "Companion", "NameCountToUseStarImportSelector", "kotlin.idea"})
public final class ImportSettingsPanel
extends JPanel {
    private final JCheckBox cbImportNestedClasses = new JCheckBox(KotlinBundle.message("formatter.checkbox.text.insert.imports.for.nested.classes", new Object[0]));
    private final KotlinStarImportLayoutPanel starImportLayoutPanel = new KotlinStarImportLayoutPanel();
    private final KotlinImportOrderLayoutPanel importOrderLayoutPanel = new KotlinImportOrderLayoutPanel();
    private final NameCountToUseStarImportSelector nameCountToUseStarImportSelector = new NameCountToUseStarImportSelector(KotlinBundle.message("formatter.title.top.level.symbols", new Object[0]), 5);
    private final NameCountToUseStarImportSelector nameCountToUseStarImportForMembersSelector = new NameCountToUseStarImportSelector(KotlinBundle.message("formatter.title.java.statics.and.enum.members", new Object[0]), 3);
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void reset(@NotNull KotlinCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        this.nameCountToUseStarImportSelector.setValue(settings2.NAME_COUNT_TO_USE_STAR_IMPORT);
        this.nameCountToUseStarImportForMembersSelector.setValue(settings2.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS);
        this.cbImportNestedClasses.setSelected(settings2.IMPORT_NESTED_CLASSES);
        KotlinPackageEntryTable kotlinPackageEntryTable = this.starImportLayoutPanel.getPackageTable();
        KotlinPackageEntryTable kotlinPackageEntryTable2 = settings2.PACKAGES_TO_USE_STAR_IMPORTS;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable2, (String)"settings.PACKAGES_TO_USE_STAR_IMPORTS");
        kotlinPackageEntryTable.copyFrom(kotlinPackageEntryTable2);
        TableModel tableModel = this.starImportLayoutPanel.getLayoutTable().getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        ((AbstractTableModel)tableModel).fireTableDataChanged();
        if (this.starImportLayoutPanel.getLayoutTable().getRowCount() > 0) {
            this.starImportLayoutPanel.getLayoutTable().getSelectionModel().setSelectionInterval(0, 0);
        }
        KotlinPackageEntryTable kotlinPackageEntryTable3 = this.importOrderLayoutPanel.getPackageTable();
        KotlinPackageEntryTable kotlinPackageEntryTable4 = settings2.PACKAGES_IMPORT_LAYOUT;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable4, (String)"settings.PACKAGES_IMPORT_LAYOUT");
        kotlinPackageEntryTable3.copyFrom(kotlinPackageEntryTable4);
        TableModel tableModel2 = this.importOrderLayoutPanel.getLayoutTable().getModel();
        if (tableModel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        }
        ((AbstractTableModel)tableModel2).fireTableDataChanged();
        if (this.importOrderLayoutPanel.getLayoutTable().getRowCount() > 0) {
            this.importOrderLayoutPanel.getLayoutTable().getSelectionModel().setSelectionInterval(0, 0);
        }
        this.importOrderLayoutPanel.recomputeAliasesCheckbox();
    }

    public final void apply(@NotNull KotlinCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        settings2.NAME_COUNT_TO_USE_STAR_IMPORT = this.nameCountToUseStarImportSelector.getValue();
        settings2.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS = this.nameCountToUseStarImportForMembersSelector.getValue();
        settings2.IMPORT_NESTED_CLASSES = this.cbImportNestedClasses.isSelected();
        settings2.PACKAGES_TO_USE_STAR_IMPORTS.copyFrom(ImportSettingsPanel.Companion.getCopyWithoutEmptyPackages(this.starImportLayoutPanel.getPackageTable()));
        settings2.PACKAGES_IMPORT_LAYOUT.copyFrom(this.importOrderLayoutPanel.getPackageTable());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull KotlinCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        KotlinCodeStyleSettings $this$with = settings2;
        boolean bl = false;
        boolean isModified2 = false;
        if (this.nameCountToUseStarImportSelector.getValue() != $this$with.NAME_COUNT_TO_USE_STAR_IMPORT) {
            return true;
        }
        boolean bl2 = false;
        isModified2 = bl2;
        if (isModified2) return true;
        if (this.nameCountToUseStarImportForMembersSelector.getValue() != $this$with.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS) {
            return true;
        }
        boolean bl3 = false;
        isModified2 = bl3;
        if (isModified2) return true;
        if (ImportSettingsPanel.Companion.isModified(this.cbImportNestedClasses, $this$with.IMPORT_NESTED_CLASSES)) {
            return true;
        }
        boolean bl4 = false;
        isModified2 = bl4;
        if (isModified2) return true;
        KotlinPackageEntryTable kotlinPackageEntryTable = ImportSettingsPanel.Companion.getCopyWithoutEmptyPackages(this.starImportLayoutPanel.getPackageTable());
        KotlinPackageEntryTable kotlinPackageEntryTable2 = $this$with.PACKAGES_TO_USE_STAR_IMPORTS;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable2, (String)"PACKAGES_TO_USE_STAR_IMPORTS");
        if (ImportSettingsPanel.Companion.isModified(kotlinPackageEntryTable, kotlinPackageEntryTable2)) {
            return true;
        }
        boolean bl5 = false;
        isModified2 = bl5;
        if (isModified2) return true;
        KotlinPackageEntryTable kotlinPackageEntryTable3 = this.importOrderLayoutPanel.getPackageTable();
        KotlinPackageEntryTable kotlinPackageEntryTable4 = $this$with.PACKAGES_IMPORT_LAYOUT;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable4, (String)"PACKAGES_IMPORT_LAYOUT");
        if (!ImportSettingsPanel.Companion.isModified(kotlinPackageEntryTable3, kotlinPackageEntryTable4)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ImportSettingsPanel() {
        void $this$apply;
        GridBagConstraints constraints2;
        GridBagConstraints gridBagConstraints;
        JPanel jPanel2;
        this.setLayout(new BorderLayout());
        JPanel jPanel3 = jPanel2 = new JPanel(new GridBagLayout());
        ImportSettingsPanel importSettingsPanel = this;
        boolean bl = false;
        GridBagConstraints $this$apply2 = gridBagConstraints = new GridBagConstraints();
        boolean bl2 = false;
        $this$apply2.weightx = 1.0;
        $this$apply2.insets = new Insets(0, 10, 10, 10);
        $this$apply2.fill = 2;
        $this$apply2.gridy = 0;
        $this$apply2 = gridBagConstraints = (constraints2 = gridBagConstraints);
        Component component2 = this.nameCountToUseStarImportSelector.createPanel();
        void var9_10 = $this$apply;
        boolean bl3 = false;
        int n = $this$apply2.gridy;
        $this$apply2.gridy = n + 1;
        Unit unit = Unit.INSTANCE;
        var9_10.add(component2, gridBagConstraints);
        $this$apply2 = gridBagConstraints = constraints2;
        component2 = this.nameCountToUseStarImportForMembersSelector.createPanel();
        var9_10 = $this$apply;
        boolean bl4 = false;
        n = $this$apply2.gridy;
        $this$apply2.gridy = n + 1;
        unit = Unit.INSTANCE;
        var9_10.add(component2, gridBagConstraints);
        $this$apply2 = gridBagConstraints = new OptionGroup(KotlinBundle.message("formatter.title.other", new Object[0]));
        var9_10 = $this$apply;
        boolean bl5 = false;
        $this$apply2.add(this.cbImportNestedClasses);
        component2 = Unit.INSTANCE;
        Component component3 = gridBagConstraints.createPanel();
        $this$apply2 = gridBagConstraints = constraints2;
        component2 = component3;
        boolean bl6 = false;
        n = $this$apply2.gridy;
        $this$apply2.gridy = n + 1;
        unit = Unit.INSTANCE;
        var9_10.add(component2, gridBagConstraints);
        $this$apply2 = gridBagConstraints = constraints2;
        component2 = this.starImportLayoutPanel;
        var9_10 = $this$apply;
        boolean bl7 = false;
        n = $this$apply2.gridy;
        $this$apply2.gridy = n + 1;
        $this$apply2.fill = 1;
        $this$apply2.weighty = 1.0;
        unit = Unit.INSTANCE;
        var9_10.add(component2, gridBagConstraints);
        $this$apply2 = gridBagConstraints = constraints2;
        component2 = this.importOrderLayoutPanel;
        var9_10 = $this$apply;
        boolean bl8 = false;
        n = $this$apply2.gridy;
        $this$apply2.gridy = n + 1;
        $this$apply2.fill = 1;
        $this$apply2.weighty = 1.0;
        unit = Unit.INSTANCE;
        var9_10.add(component2, gridBagConstraints);
        Unit unit2 = Unit.INSTANCE;
        Component component4 = jPanel2;
        importSettingsPanel.add((Component)new JBScrollPane(component4), "Center");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ImportSettingsPanel$NameCountToUseStarImportSelector;", "Lcom/intellij/ui/OptionGroup;", "title", "", "default", "", "(Ljava/lang/String;I)V", "rbUseSingleImports", "Ljavax/swing/JRadioButton;", "rbUseStarImports", "rbUseStarImportsIfAtLeast", "starImportLimitField", "Ljavax/swing/JSpinner;", "starImportLimitModel", "Ljavax/swing/SpinnerNumberModel;", "value", "getValue", "()I", "setValue", "(I)V", "Companion", "kotlin.idea"})
    private static final class NameCountToUseStarImportSelector
    extends OptionGroup {
        private final JRadioButton rbUseSingleImports;
        private final JRadioButton rbUseStarImports;
        private final JRadioButton rbUseStarImportsIfAtLeast;
        private final SpinnerNumberModel starImportLimitModel;
        private final JSpinner starImportLimitField;
        private static final int MIN_VALUE = 2;
        private static final int MAX_VALUE = 100;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final int getValue() {
            int n;
            if (this.rbUseSingleImports.isSelected()) {
                n = Integer.MAX_VALUE;
            } else if (this.rbUseStarImports.isSelected()) {
                n = 1;
            } else {
                Number number = this.starImportLimitModel.getNumber();
                if (number == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                n = (Integer)number;
            }
            return n;
        }

        public final void setValue(int value2) {
            if (value2 > 100) {
                this.rbUseSingleImports.setSelected(true);
            } else if (value2 < 2) {
                this.rbUseStarImports.setSelected(true);
            } else {
                this.rbUseStarImportsIfAtLeast.setSelected(true);
                this.starImportLimitField.setValue(value2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public NameCountToUseStarImportSelector(@NlsContexts.BorderTitle @NotNull String title, int n) {
            void $this$apply;
            GridBagConstraints gridBagConstraints;
            ButtonGroup buttonGroup;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            super(title);
            this.rbUseSingleImports = new JRadioButton(KotlinBundle.message("formatter.button.text.use.single.name.import", new Object[0]));
            this.rbUseStarImports = new JRadioButton(KotlinBundle.message("formatter.button.text.use.import.with", new Object[0]));
            this.rbUseStarImportsIfAtLeast = new JRadioButton(KotlinBundle.message("formatter.button.text.use.import.with.when.at.least", new Object[0]));
            this.starImportLimitModel = new SpinnerNumberModel(n, 2, 100, 1);
            this.starImportLimitField = new JSpinner(this.starImportLimitModel);
            Serializable $this$apply2 = buttonGroup = new ButtonGroup();
            boolean $i$a$-apply-ImportSettingsPanel$NameCountToUseStarImportSelector$32 = false;
            $this$apply2.add(this.rbUseSingleImports);
            $this$apply2.add(this.rbUseStarImports);
            $this$apply2.add(this.rbUseStarImportsIfAtLeast);
            this.add(this.rbUseSingleImports, true);
            this.add(this.rbUseStarImports, true);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            Serializable $i$a$-apply-ImportSettingsPanel$NameCountToUseStarImportSelector$32 = $this$apply2 = jPanel2;
            NameCountToUseStarImportSelector nameCountToUseStarImportSelector = this;
            boolean bl = false;
            GridBagConstraints $this$apply3 = gridBagConstraints = new GridBagConstraints();
            boolean bl2 = false;
            $this$apply3.gridx = -1;
            GridBagConstraints constraints2 = gridBagConstraints;
            $this$apply.add((Component)this.rbUseStarImportsIfAtLeast, constraints2);
            $this$apply.add((Component)this.starImportLimitField, constraints2);
            $this$apply3 = gridBagConstraints = constraints2;
            Component component2 = new JLabel(KotlinBundle.message("formatter.text.names.used", new Object[0]));
            void var12_14 = $this$apply;
            boolean bl3 = false;
            $this$apply3.fill = 2;
            $this$apply3.weightx = 1.0;
            Unit unit = Unit.INSTANCE;
            var12_14.add(component2, gridBagConstraints);
            Unit unit2 = Unit.INSTANCE;
            nameCountToUseStarImportSelector.add((JComponent)$this$apply2, true);
            final var $fun$updateEnabled$3 = new Function0<Unit>(){

                public final void invoke() {
                    starImportLimitField.setEnabled(rbUseStarImportsIfAtLeast.isSelected());
                }
            };
            this.rbUseStarImportsIfAtLeast.addChangeListener(new ChangeListener(){

                @Override
                public final void stateChanged(ChangeEvent it) {
                    $fun$updateEnabled$3.invoke();
                }
            });
            $fun$updateEnabled$3.invoke();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ImportSettingsPanel$NameCountToUseStarImportSelector$Companion;", "", "()V", "MAX_VALUE", "", "MIN_VALUE", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ImportSettingsPanel$Companion;", "", "()V", "getCopyWithoutEmptyPackages", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "table", "isModified", "", "checkBox", "Ljavax/swing/JCheckBox;", "value", "list", "kotlin.idea"})
    public static final class Companion {
        private final boolean isModified(JCheckBox checkBox2, boolean value2) {
            return checkBox2.isSelected() != value2;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isModified(KotlinPackageEntryTable list2, KotlinPackageEntryTable table) {
            if (list2.getEntryCount() != table.getEntryCount()) {
                return true;
            }
            int n = 0;
            int n2 = list2.getEntryCount();
            while (n < n2) {
                KotlinPackageEntry entry2;
                void i;
                KotlinPackageEntry entry1 = list2.getEntryAt((int)i);
                if (Intrinsics.areEqual((Object)entry1, (Object)(entry2 = table.getEntryAt((int)i))) ^ true) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private final KotlinPackageEntryTable getCopyWithoutEmptyPackages(KotlinPackageEntryTable table) {
            try {
                KotlinPackageEntryTable copy = table.clone();
                copy.removeEmptyPackages();
                return copy;
            }
            catch (CloneNotSupportedException ignored) {
                throw (Throwable)new IllegalStateException("Clone should be supported");
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

