/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinDslGradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J0\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinDslGradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinDslGradleKotlinFrameworkSupportProvider;", "()V", "addJvmTargetTask", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "addSupport", "projectId", "Lcom/intellij/openapi/externalSystem/model/project/ProjectId;", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "getOldSyntaxPluginDefinition", "", "getPluginDefinition", "kotlin.gradle.gradle-java"})
public final class KotlinDslGradleKotlinJavaFrameworkSupportProvider
extends KotlinDslGradleKotlinFrameworkSupportProvider {
    public KotlinDslGradleKotlinJavaFrameworkSupportProvider() {
        String string = KotlinIdeaGradleBundle.message("display.name.kotlin.jvm", new Object[0]);
        Icon icon2 = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SMALL_LOGO");
        super("KOTLIN", string, icon2);
    }

    @Override
    @NotNull
    protected String getOldSyntaxPluginDefinition() {
        return "plugin(\"kotlin\")";
    }

    @Override
    @NotNull
    protected String getPluginDefinition() {
        return "kotlin(\"jvm\")";
    }

    @Override
    public void addSupport(@NotNull ProjectId projectId, @NotNull Module module2, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        super.addSupport(projectId, module2, rootModel, modifiableModelsProvider, buildScriptData);
        JvmTarget jvmTarget2 = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(rootModel.getSdk(), KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion());
        if (jvmTarget2 != null) {
            this.addJvmTargetTask(buildScriptData);
        }
        String artifactId2 = KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(rootModel.getSdk(), KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion());
        buildScriptData.addDependencyNotation(this.composeDependency(buildScriptData, artifactId2));
    }

    private final void addJvmTargetTask(BuildScriptDataBuilder buildScriptData) {
        GradleVersion minGradleVersion = GradleVersion.version((String)"5.0");
        if (buildScriptData.getGradleVersion().compareTo(minGradleVersion) >= 0) {
            buildScriptData.addOther("tasks {\n    compileKotlin {\n        kotlinOptions.jvmTarget = \"1.8\"\n    }\n    compileTestKotlin {\n        kotlinOptions.jvmTarget = \"1.8\"\n    }\n}");
        } else {
            buildScriptData.addImport("org.jetbrains.kotlin.gradle.tasks.KotlinCompile").addOther("tasks.withType<KotlinCompile> {\n    kotlinOptions.jvmTarget = \"1.8\"\n}\n");
        }
    }
}

