/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.siyeh.ig.BaseGlobalInspection;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.inspections.PackageNameInspectionLocal;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection;", "Lcom/siyeh/ig/BaseGlobalInspection;", "()V", "namePattern", "", "getNamePattern$annotations", "getNamePattern", "()Ljava/lang/String;", "setNamePattern", "(Ljava/lang/String;)V", "namingSettings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "checkElement", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "refEntity", "Lcom/intellij/codeInspection/reference/RefEntity;", "analysisScope", "Lcom/intellij/analysis/AnalysisScope;", "inspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "globalInspectionContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "(Lcom/intellij/codeInspection/reference/RefEntity;Lcom/intellij/analysis/AnalysisScope;Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/codeInspection/GlobalInspectionContext;)[Lcom/intellij/codeInspection/CommonProblemDescriptor;", "createOptionsPanel", "Ljavax/swing/JPanel;", "getSharedLocalInspectionTool", "Lcom/intellij/codeInspection/LocalInspectionTool;", "readSettings", "", "element", "Lorg/jdom/Element;", "Companion", "kotlin.idea"})
public final class PackageNameInspection
extends BaseGlobalInspection {
    @NotNull
    private String namePattern = "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*";
    private final NamingConventionInspectionSettings namingSettings = new NamingConventionInspectionSettings(KotlinBundle.message("text.Package", new Object[0]), "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
        final /* synthetic */ PackageNameInspection this$0;

        public final void invoke(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.this$0.setNamePattern(value2);
        }
        {
            this.this$0 = packageNameInspection;
            super(1);
        }
    }), new NamingRule[0]);
    @NotNull
    public static final String DEFAULT_PACKAGE_NAME_PATTERN = "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*";
    @NotNull
    private static final NamingRule[] PART_RULES;
    @NotNull
    public static final Companion Companion;

    public static /* synthetic */ void getNamePattern$annotations() {
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.namePattern = string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        Intrinsics.checkNotNullParameter((Object)refEntity, (String)"refEntity");
        Intrinsics.checkNotNullParameter((Object)analysisScope, (String)"analysisScope");
        Intrinsics.checkNotNullParameter((Object)inspectionManager, (String)"inspectionManager");
        Intrinsics.checkNotNullParameter((Object)globalInspectionContext, (String)"globalInspectionContext");
        RefEntity refEntity2 = refEntity;
        if (refEntity2 instanceof RefFile) {
            KtPackageDirective packageDirective;
            PsiFile psiFile2 = ((RefFile)refEntity).getPsiElement();
            if (psiFile2 instanceof KtFile && !KotlinRefactoringUtilKt.isInjectedFragment(psiFile2) && !PackageUtilsKt.packageMatchesDirectoryOrImplicit((KtFile)psiFile2) && (packageDirective = ((KtFile)psiFile2).getPackageDirective()) != null) {
                String string = packageDirective.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageDirective.qualifiedName");
                String qualifiedName2 = string;
                PackageNameInspectionLocal.Companion.CheckResult checkResult = PackageNameInspectionLocal.Companion.checkPackageDirective(packageDirective, this.namingSettings);
                if (checkResult != null) {
                    CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[1];
                    CommonProblemDescriptor commonProblemDescriptor = inspectionManager.createProblemDescriptor(PackageNameInspection.Companion.toErrorMessage(checkResult, qualifiedName2), new QuickFix[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)commonProblemDescriptor, (String)"inspectionManager.create\u2026orMessage(qualifiedName))");
                    commonProblemDescriptorArray[0] = commonProblemDescriptor;
                    return commonProblemDescriptorArray;
                }
            }
        } else if (refEntity2 instanceof RefPackage) {
            String string = StringUtil.getShortName((String)refEntity.getQualifiedName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.getShortName(\u2026ntity.getQualifiedName())");
            String name2 = string;
            CharSequence packageDirective = name2;
            if (packageDirective.length() == 0 || Intrinsics.areEqual((Object)InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]), (Object)name2)) {
                return null;
            }
            PackageNameInspectionLocal.Companion.CheckResult checkResult = PackageNameInspectionLocal.Companion.checkQualifiedName(name2, this.namingSettings);
            if (checkResult != null) {
                CommonProblemDescriptor[] commonProblemDescriptorArray = new CommonProblemDescriptor[1];
                CommonProblemDescriptor commonProblemDescriptor = inspectionManager.createProblemDescriptor(PackageNameInspection.Companion.toErrorMessage(checkResult, name2), new QuickFix[0]);
                Intrinsics.checkNotNullExpressionValue((Object)commonProblemDescriptor, (String)"inspectionManager.create\u2026ult.toErrorMessage(name))");
                commonProblemDescriptorArray[0] = commonProblemDescriptor;
                return commonProblemDescriptorArray;
            }
        } else {
            return null;
        }
        return null;
    }

    public void readSettings(@NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super.readSettings(element3);
        this.namingSettings.setNamePattern(this.namePattern);
    }

    @NotNull
    public JPanel createOptionsPanel() {
        return this.namingSettings.createOptionsPanel();
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new PackageNameInspectionLocal((InspectionProfileEntry)this, this.namingSettings);
    }

    static {
        Companion = new Companion(null);
        PART_RULES = new NamingRule[]{NamingConventionInspectionsKt.access$getNO_BAD_CHARACTERS_OR_UNDERSCORE$p(), NamingConventionInspectionsKt.access$getNO_START_UPPER$p()};
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection$Companion;", "", "()V", "DEFAULT_PACKAGE_NAME_PATTERN", "", "PART_RULES", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "getPART_RULES", "()[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "toErrorMessage", "Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal$Companion$CheckResult;", "qualifiedName", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final NamingRule[] getPART_RULES() {
            return PART_RULES;
        }

        @NlsSafe
        private final String toErrorMessage(PackageNameInspectionLocal.Companion.CheckResult $this$toErrorMessage, String qualifiedName2) {
            return KotlinBundle.message("package.name", new Object[0]) + ($this$toErrorMessage.isForPart() ? " <code>" + qualifiedName2 + "</code> " + KotlinBundle.message("text.part", new Object[0]) + " " + $this$toErrorMessage.getErrorMessage() : " <code>" + qualifiedName2 + "</code> " + $this$toErrorMessage.getErrorMessage());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

