/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectWizard;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.projectWizard.SettingIdWithPossibleValues;
import org.jetbrains.kotlin.idea.projectWizard.Settings;
import org.jetbrains.kotlin.idea.projectWizard.WizardLoggingSession;
import org.jetbrains.kotlin.idea.projectWizard.WizardStats;
import org.jetbrains.kotlin.idea.projectWizard.WizardStatsServiceKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00052\u00020\u0001:\u0003\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "ProjectCreationStats", "UiEditorUsageStats", "kotlin.idea"})
public final class WizardStatsService
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final List<String> allowedProjectTemplates;
    private static final List<String> allowedModuleTemplates;
    private static final List<String> allowedWizardsGroups;
    private static final List<String> allowedBuildSystems;
    private static final Settings settings;
    private static final List<String> allowedModuleTypes;
    @NotNull
    private static final StringEventField settingIdField;
    @NotNull
    private static final StringEventField settingValueField;
    @NotNull
    private static final StringEventField groupField;
    @NotNull
    private static final StringEventField projectTemplateField;
    @NotNull
    private static final StringEventField buildSystemField;
    @NotNull
    private static final IntEventField modulesCreatedField;
    @NotNull
    private static final IntEventField modulesRemovedField;
    @NotNull
    private static final IntEventField moduleTemplateChangedField;
    @NotNull
    private static final StringEventField moduleTemplateField;
    @NotNull
    private static final IntEventField sessionIdField;
    @NotNull
    private static final StringListEventField.ValidatedByAllowedValues modulesListField;
    @NotNull
    private static final StringEventField moduleTypeField;
    private static final EventPair<PluginInfo> pluginInfoField;
    private static final VarargEventId projectCreatedEvent;
    private static final VarargEventId projectOpenedByHyperlinkEvent;
    private static final VarargEventId moduleTemplateCreatedEvent;
    private static final VarargEventId settingValueChangedEvent;
    private static final VarargEventId jdkChangedEvent;
    private static final VarargEventId nextClickedEvent;
    private static final VarargEventId prevClickedEvent;
    private static final VarargEventId moduleCreatedEvent;
    private static final VarargEventId moduleRemovedEvent;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("kotlin.ide.new.project", 10, null, 4, null);
        allowedProjectTemplates = CollectionsKt.listOf((Object[])new String[]{"JVM_|_IDEA", "JS_|_IDEA", "Kotlin/JVM", "Kotlin/JS", "Kotlin/JS_for_browser", "Kotlin/JS_for_Node.js", "Kotlin/Multiplatform_as_framework", "Kotlin/Multiplatform", "backendApplication", "consoleApplication", "multiplatformMobileApplication", "multiplatformMobileLibrary", "multiplatformApplication", "multiplatformLibrary", "nativeApplication", "frontendApplication", "fullStackWebApplication", "nodejsApplication", "reactApplication", "composeDesktopApplication", "composeMultiplatformApplication", "none", "multiplatformMobileApplicationUsingAppleGradlePlugin", "multiplatformMobileApplicationUsingHybridProject"});
        allowedModuleTemplates = CollectionsKt.listOf((Object[])new String[]{"composeAndroid", "composeDesktopTemplate", "composeMppModule", "consoleJvmApp", "ktorServer", "mobileMppModule", "nativeConsoleApp", "reactJsClient", "simpleJsClient", "simpleNodeJs", "none"});
        allowedWizardsGroups = CollectionsKt.listOf((Object[])new String[]{"Java", "Kotlin", "Gradle"});
        allowedBuildSystems = CollectionsKt.listOf((Object[])new String[]{"gradleKotlin", "gradleGroovy", "jps", "maven"});
        settings = new Settings(new SettingIdWithPossibleValues.Enum("buildSystem.type", null, CollectionsKt.listOf((Object[])new String[]{"GradleKotlinDsl", "GradleGroovyDsl", "Jps", "Maven"}), 2, null), new SettingIdWithPossibleValues.Enum("testFramework", null, CollectionsKt.listOf((Object[])new String[]{"NONE", "JUNIT4", "JUNIT5", "TEST_NG", "JS", "COMMON"}), 2, null), new SettingIdWithPossibleValues.Enum("targetJvmVersion", null, CollectionsKt.listOf((Object[])new String[]{"JVM_1_6", "JVM_1_8", "JVM_9", "JVM_10", "JVM_11", "JVM_12", "JVM_13"}), 2, null), new SettingIdWithPossibleValues.Enum("androidPlugin", null, CollectionsKt.listOf((Object[])new String[]{"APPLICATION", "LIBRARY"}), 2, null), new SettingIdWithPossibleValues.Enum("serverEngine", null, CollectionsKt.listOf((Object[])new String[]{"Netty", "Tomcat", "Jetty"}), 2, null), new SettingIdWithPossibleValues.Enum("kind", "js.project.kind", CollectionsKt.listOf((Object[])new String[]{"LIBRARY", "APPLICATION"})), new SettingIdWithPossibleValues.Enum("compiler", "js.compiler", CollectionsKt.listOf((Object[])new String[]{"IR", "LEGACY", "BOTH"})), new SettingIdWithPossibleValues.Enum("projectTemplates.template", null, allowedProjectTemplates, 2, null), new SettingIdWithPossibleValues.Enum("module.template", null, allowedModuleTemplates, 2, null), new SettingIdWithPossibleValues.Enum("buildSystem.type", null, allowedBuildSystems, 2, null), new SettingIdWithPossibleValues.Boolean("javaSupport", "jvm.javaSupport"), new SettingIdWithPossibleValues.Boolean("cssSupport", "js.cssSupport"), new SettingIdWithPossibleValues.Boolean("useReactRouterDom", "js.useReactRouterDom"), new SettingIdWithPossibleValues.Boolean("useReactRedux", "js.useReactRedux"));
        allowedModuleTypes = CollectionsKt.listOf((Object[])new String[]{"androidNativeArm32Target", "androidNativeArm64Target", "iosArm32Target", "iosArm64Target", "iosX64Target", "iosTarget", "linuxArm32HfpTarget", "linuxMips32Target", "linuxMipsel32Target", "linuxX64Target", "macosX64Target", "mingwX64Target", "mingwX86Target", "nativeForCurrentSystem", "jsBrowser", "jsNode", "commonTarget", "jvmTarget", "androidTarget", "multiplatform", "JVM_Module", "android", "IOS_Module", "jsBrowserSinglePlatform", "jsNodeSinglePlatform"});
        settingIdField = EventFields.String((String)"setting_id", settings.getAllowedIds());
        settingValueField = EventFields.String((String)"setting_value", settings.getPossibleValues());
        groupField = EventFields.String((String)"group", allowedWizardsGroups);
        projectTemplateField = EventFields.String((String)"project_template", allowedProjectTemplates);
        buildSystemField = EventFields.String((String)"build_system", allowedBuildSystems);
        modulesCreatedField = EventFields.Int((String)"modules_created");
        modulesRemovedField = EventFields.Int((String)"modules_removed");
        moduleTemplateChangedField = EventFields.Int((String)"module_template_changed");
        moduleTemplateField = EventFields.String((String)"module_template", allowedModuleTemplates);
        sessionIdField = EventFields.Int((String)"session_id");
        modulesListField = new StringListEventField.ValidatedByAllowedValues("project_modules_list", allowedModuleTypes);
        moduleTypeField = EventFields.String((String)"module_type", allowedModuleTypes);
        pluginInfoField = EventFields.PluginInfo.with((Object)PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinIdePlugin.INSTANCE.getId()));
        projectCreatedEvent = GROUP.registerVarargEvent("project_created", new EventField[]{(EventField)groupField, (EventField)projectTemplateField, (EventField)buildSystemField, (EventField)modulesCreatedField, (EventField)modulesRemovedField, (EventField)moduleTemplateChangedField, (EventField)modulesListField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        projectOpenedByHyperlinkEvent = GROUP.registerVarargEvent("wizard_opened_by_hyperlink", new EventField[]{(EventField)projectTemplateField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        moduleTemplateCreatedEvent = GROUP.registerVarargEvent("module_template_created", new EventField[]{(EventField)projectTemplateField, (EventField)moduleTemplateField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        settingValueChangedEvent = GROUP.registerVarargEvent("setting_value_changed", new EventField[]{(EventField)settingIdField, (EventField)settingValueField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        jdkChangedEvent = GROUP.registerVarargEvent("jdk_changed", new EventField[]{(EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        nextClickedEvent = GROUP.registerVarargEvent("next_clicked", new EventField[]{(EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        prevClickedEvent = GROUP.registerVarargEvent("prev_clicked", new EventField[]{(EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        moduleCreatedEvent = GROUP.registerVarargEvent("module_created", new EventField[]{(EventField)moduleTypeField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
        moduleRemovedEvent = GROUP.registerVarargEvent("module_removed", new EventField[]{(EventField)moduleTypeField, (EventField)sessionIdField, (EventField)EventFields.PluginInfo});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J \u0010\u001a\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c`\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService$ProjectCreationStats;", "Lorg/jetbrains/kotlin/idea/projectWizard/WizardStats;", "group", "", "projectTemplateId", "buildSystemType", "moduleTypes", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBuildSystemType", "()Ljava/lang/String;", "getGroup", "getModuleTypes", "()Ljava/util/List;", "getProjectTemplateId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toPairs", "Ljava/util/ArrayList;", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Lkotlin/collections/ArrayList;", "toString", "kotlin.idea"})
    public static final class ProjectCreationStats
    implements WizardStats {
        @NotNull
        private final String group;
        @NotNull
        private final String projectTemplateId;
        @NotNull
        private final String buildSystemType;
        @NotNull
        private final List<String> moduleTypes;

        @Override
        @NotNull
        public ArrayList<EventPair<?>> toPairs() {
            return CollectionsKt.arrayListOf((Object[])new EventPair[]{Companion.getGroupField().with((Object)this.group), Companion.getProjectTemplateField().with((Object)this.projectTemplateId), Companion.getBuildSystemField().with((Object)this.buildSystemType), Companion.getModulesListField().with(this.moduleTypes)});
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getProjectTemplateId() {
            return this.projectTemplateId;
        }

        @NotNull
        public final String getBuildSystemType() {
            return this.buildSystemType;
        }

        @NotNull
        public final List<String> getModuleTypes() {
            return this.moduleTypes;
        }

        public ProjectCreationStats(@NotNull String group, @NotNull String projectTemplateId, @NotNull String buildSystemType2, @NotNull List<String> moduleTypes) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)projectTemplateId, (String)"projectTemplateId");
            Intrinsics.checkNotNullParameter((Object)buildSystemType2, (String)"buildSystemType");
            Intrinsics.checkNotNullParameter(moduleTypes, (String)"moduleTypes");
            this.group = group;
            this.projectTemplateId = projectTemplateId;
            this.buildSystemType = buildSystemType2;
            this.moduleTypes = moduleTypes;
        }

        public /* synthetic */ ProjectCreationStats(String string, String string2, String string3, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(string, string2, string3, list2);
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final String component2() {
            return this.projectTemplateId;
        }

        @NotNull
        public final String component3() {
            return this.buildSystemType;
        }

        @NotNull
        public final List<String> component4() {
            return this.moduleTypes;
        }

        @NotNull
        public final ProjectCreationStats copy(@NotNull String group, @NotNull String projectTemplateId, @NotNull String buildSystemType2, @NotNull List<String> moduleTypes) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)projectTemplateId, (String)"projectTemplateId");
            Intrinsics.checkNotNullParameter((Object)buildSystemType2, (String)"buildSystemType");
            Intrinsics.checkNotNullParameter(moduleTypes, (String)"moduleTypes");
            return new ProjectCreationStats(group, projectTemplateId, buildSystemType2, moduleTypes);
        }

        public static /* synthetic */ ProjectCreationStats copy$default(ProjectCreationStats projectCreationStats, String string, String string2, String string3, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = projectCreationStats.group;
            }
            if ((n & 2) != 0) {
                string2 = projectCreationStats.projectTemplateId;
            }
            if ((n & 4) != 0) {
                string3 = projectCreationStats.buildSystemType;
            }
            if ((n & 8) != 0) {
                list2 = projectCreationStats.moduleTypes;
            }
            return projectCreationStats.copy(string, string2, string3, list2);
        }

        @NotNull
        public String toString() {
            return "ProjectCreationStats(group=" + this.group + ", projectTemplateId=" + this.projectTemplateId + ", buildSystemType=" + this.buildSystemType + ", moduleTypes=" + this.moduleTypes + ")";
        }

        public int hashCode() {
            String string = this.group;
            String string2 = this.projectTemplateId;
            String string3 = this.buildSystemType;
            List<String> list2 = this.moduleTypes;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ProjectCreationStats)) break block3;
                    ProjectCreationStats projectCreationStats = (ProjectCreationStats)object;
                    if (!Intrinsics.areEqual((Object)this.group, (Object)projectCreationStats.group) || !Intrinsics.areEqual((Object)this.projectTemplateId, (Object)projectCreationStats.projectTemplateId) || !Intrinsics.areEqual((Object)this.buildSystemType, (Object)projectCreationStats.buildSystemType) || !Intrinsics.areEqual(this.moduleTypes, projectCreationStats.moduleTypes)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J \u0010\u0018\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a`\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService$UiEditorUsageStats;", "Lorg/jetbrains/kotlin/idea/projectWizard/WizardStats;", "modulesCreated", "", "modulesRemoved", "moduleTemplateChanged", "(III)V", "getModuleTemplateChanged", "()I", "setModuleTemplateChanged", "(I)V", "getModulesCreated", "setModulesCreated", "getModulesRemoved", "setModulesRemoved", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toPairs", "Ljava/util/ArrayList;", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Lkotlin/collections/ArrayList;", "toString", "", "kotlin.idea"})
    public static final class UiEditorUsageStats
    implements WizardStats {
        private int modulesCreated;
        private int modulesRemoved;
        private int moduleTemplateChanged;

        @Override
        @NotNull
        public ArrayList<EventPair<?>> toPairs() {
            return CollectionsKt.arrayListOf((Object[])new EventPair[]{Companion.getModulesCreatedField().with((Object)this.modulesCreated), Companion.getModulesRemovedField().with((Object)this.modulesRemoved), Companion.getModuleTemplateChangedField().with((Object)this.moduleTemplateChanged)});
        }

        public final int getModulesCreated() {
            return this.modulesCreated;
        }

        public final void setModulesCreated(int n) {
            this.modulesCreated = n;
        }

        public final int getModulesRemoved() {
            return this.modulesRemoved;
        }

        public final void setModulesRemoved(int n) {
            this.modulesRemoved = n;
        }

        public final int getModuleTemplateChanged() {
            return this.moduleTemplateChanged;
        }

        public final void setModuleTemplateChanged(int n) {
            this.moduleTemplateChanged = n;
        }

        public UiEditorUsageStats(int modulesCreated, int modulesRemoved, int moduleTemplateChanged) {
            this.modulesCreated = modulesCreated;
            this.modulesRemoved = modulesRemoved;
            this.moduleTemplateChanged = moduleTemplateChanged;
        }

        public /* synthetic */ UiEditorUsageStats(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public UiEditorUsageStats() {
            this(0, 0, 0, 7, null);
        }

        public final int component1() {
            return this.modulesCreated;
        }

        public final int component2() {
            return this.modulesRemoved;
        }

        public final int component3() {
            return this.moduleTemplateChanged;
        }

        @NotNull
        public final UiEditorUsageStats copy(int modulesCreated, int modulesRemoved, int moduleTemplateChanged) {
            return new UiEditorUsageStats(modulesCreated, modulesRemoved, moduleTemplateChanged);
        }

        public static /* synthetic */ UiEditorUsageStats copy$default(UiEditorUsageStats uiEditorUsageStats, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = uiEditorUsageStats.modulesCreated;
            }
            if ((n4 & 2) != 0) {
                n2 = uiEditorUsageStats.modulesRemoved;
            }
            if ((n4 & 4) != 0) {
                n3 = uiEditorUsageStats.moduleTemplateChanged;
            }
            return uiEditorUsageStats.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "UiEditorUsageStats(modulesCreated=" + this.modulesCreated + ", modulesRemoved=" + this.modulesRemoved + ", moduleTemplateChanged=" + this.moduleTemplateChanged + ")";
        }

        public int hashCode() {
            return (Integer.hashCode(this.modulesCreated) * 31 + Integer.hashCode(this.modulesRemoved)) * 31 + Integer.hashCode(this.moduleTemplateChanged);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UiEditorUsageStats)) break block3;
                    UiEditorUsageStats uiEditorUsageStats = (UiEditorUsageStats)object;
                    if (this.modulesCreated != uiEditorUsageStats.modulesCreated || this.modulesRemoved != uiEditorUsageStats.modulesRemoved || this.moduleTemplateChanged != uiEditorUsageStats.moduleTemplateChanged) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u0010>\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CJ*\u0010?\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u001e\u0010F\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u0007J*\u0010I\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0002J\u0016\u0010L\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010M\u001a\u00020\u0007J\u0016\u0010N\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010M\u001a\u00020\u0007J.\u0010O\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010J\u001a\u00020\u00072\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\"\u0010Q\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010@\u001a\u0004\u0018\u00010A2\b\u0010R\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u001f\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u000e\u0010'\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u0011\u00100\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0019R\u0011\u00102\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000fR\u000e\u00104\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u000fR\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "allowedBuildSystems", "", "", "allowedModuleTemplates", "allowedModuleTypes", "allowedProjectTemplates", "allowedWizardsGroups", "buildSystemField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getBuildSystemField", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "groupField", "getGroupField", "jdkChangedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "moduleCreatedEvent", "moduleRemovedEvent", "moduleTemplateChangedField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getModuleTemplateChangedField", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "moduleTemplateCreatedEvent", "moduleTemplateField", "getModuleTemplateField", "moduleTypeField", "getModuleTypeField", "modulesCreatedField", "getModulesCreatedField", "modulesListField", "Lcom/intellij/internal/statistic/eventLog/events/StringListEventField$ValidatedByAllowedValues;", "getModulesListField", "()Lcom/intellij/internal/statistic/eventLog/events/StringListEventField$ValidatedByAllowedValues;", "modulesRemovedField", "getModulesRemovedField", "nextClickedEvent", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "prevClickedEvent", "projectCreatedEvent", "projectOpenedByHyperlinkEvent", "projectTemplateField", "getProjectTemplateField", "sessionIdField", "getSessionIdField", "settingIdField", "getSettingIdField", "settingValueChangedEvent", "settingValueField", "getSettingValueField", "settings", "Lorg/jetbrains/kotlin/idea/projectWizard/Settings;", "logDataOnJdkChanged", "", "session", "Lorg/jetbrains/kotlin/idea/projectWizard/WizardLoggingSession;", "logDataOnNextClicked", "logDataOnPrevClicked", "logDataOnProjectGenerated", "project", "Lcom/intellij/openapi/project/Project;", "projectCreationStats", "Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService$ProjectCreationStats;", "uiEditorUsageStats", "Lorg/jetbrains/kotlin/idea/projectWizard/WizardStatsService$UiEditorUsageStats;", "logDataOnSettingValueChanged", "settingId", "settingValue", "logModuleTemplateCreation", "projectTemplateId", "moduleTemplateId", "logOnModuleCreated", "moduleType", "logOnModuleRemoved", "logUsedModuleTemplatesOnNewWizardProjectCreated", "moduleTemplates", "logWizardOpenByHyperlink", "templateId", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final StringEventField getSettingIdField() {
            return settingIdField;
        }

        @NotNull
        public final StringEventField getSettingValueField() {
            return settingValueField;
        }

        @NotNull
        public final StringEventField getGroupField() {
            return groupField;
        }

        @NotNull
        public final StringEventField getProjectTemplateField() {
            return projectTemplateField;
        }

        @NotNull
        public final StringEventField getBuildSystemField() {
            return buildSystemField;
        }

        @NotNull
        public final IntEventField getModulesCreatedField() {
            return modulesCreatedField;
        }

        @NotNull
        public final IntEventField getModulesRemovedField() {
            return modulesRemovedField;
        }

        @NotNull
        public final IntEventField getModuleTemplateChangedField() {
            return moduleTemplateChangedField;
        }

        @NotNull
        public final StringEventField getModuleTemplateField() {
            return moduleTemplateField;
        }

        @NotNull
        public final IntEventField getSessionIdField() {
            return sessionIdField;
        }

        @NotNull
        public final StringListEventField.ValidatedByAllowedValues getModulesListField() {
            return modulesListField;
        }

        @NotNull
        public final StringEventField getModuleTypeField() {
            return moduleTypeField;
        }

        /*
         * WARNING - void declaration
         */
        public final void logDataOnProjectGenerated(@Nullable WizardLoggingSession session, @Nullable Project project2, @NotNull ProjectCreationStats projectCreationStats) {
            void $this$orEmpty$iv;
            EventPair[] eventPairArray;
            Intrinsics.checkNotNullParameter((Object)projectCreationStats, (String)"projectCreationStats");
            VarargEventId varargEventId = projectCreatedEvent;
            Project project3 = project2;
            SpreadBuilder spreadBuilder = new SpreadBuilder(3);
            Object $this$toTypedArray$iv = projectCreationStats.toPairs();
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray2 = thisCollection$iv.toArray(new EventPair[0]);
            Intrinsics.checkNotNull((Object)eventPairArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            spreadBuilder.addSpread((Object)eventPairArray2);
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            SpreadBuilder spreadBuilder3 = spreadBuilder;
            WizardLoggingSession wizardLoggingSession = session;
            if (wizardLoggingSession != null) {
                void it;
                Object $i$f$toTypedArray2 = $this$toTypedArray$iv = wizardLoggingSession;
                SpreadBuilder spreadBuilder4 = spreadBuilder2;
                SpreadBuilder spreadBuilder5 = spreadBuilder3;
                Project project4 = project3;
                VarargEventId varargEventId2 = varargEventId;
                boolean bl = false;
                EventPair[] eventPairArray3 = new EventPair[]{Companion.getSessionIdField().with((Object)it.getId())};
                varargEventId = varargEventId2;
                project3 = project4;
                spreadBuilder3 = spreadBuilder5;
                spreadBuilder2 = spreadBuilder4;
                eventPairArray = eventPairArray3;
            } else {
                eventPairArray = null;
            }
            $this$toTypedArray$iv = eventPairArray;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if (objectArray == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new EventPair[0];
            }
            spreadBuilder2.addSpread((Object)objectArray);
            spreadBuilder3.add((Object)pluginInfoField);
            varargEventId.log(project3, (EventPair[])spreadBuilder3.toArray((Object[])new EventPair[spreadBuilder3.size()]));
        }

        public final void logDataOnSettingValueChanged(@NotNull WizardLoggingSession session, @NotNull String settingId, @NotNull String settingValue2) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)settingId, (String)"settingId");
            Intrinsics.checkNotNullParameter((Object)settingValue2, (String)"settingValue");
            String string = settings.getIdToLog(settingId);
            if (string == null) {
                return;
            }
            String idToLog = string;
            settingValueChangedEvent.log(new EventPair[]{this.getSettingIdField().with((Object)idToLog), this.getSettingValueField().with((Object)settingValue2), this.getSessionIdField().with((Object)session.getId()), pluginInfoField});
        }

        public final void logDataOnJdkChanged(@NotNull WizardLoggingSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            jdkChangedEvent.log(new EventPair[]{this.getSessionIdField().with((Object)session.getId()), pluginInfoField});
        }

        public final void logDataOnNextClicked(@NotNull WizardLoggingSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            nextClickedEvent.log(new EventPair[]{this.getSessionIdField().with((Object)session.getId()), pluginInfoField});
        }

        public final void logDataOnPrevClicked(@NotNull WizardLoggingSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            prevClickedEvent.log(new EventPair[]{this.getSessionIdField().with((Object)session.getId()), pluginInfoField});
        }

        public final void logOnModuleCreated(@NotNull WizardLoggingSession session, @NotNull String moduleType) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
            moduleCreatedEvent.log(new EventPair[]{this.getSessionIdField().with((Object)session.getId()), this.getModuleTypeField().with((Object)WizardStatsServiceKt.access$withSpacesRemoved(moduleType)), pluginInfoField});
        }

        public final void logOnModuleRemoved(@NotNull WizardLoggingSession session, @NotNull String moduleType) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
            moduleRemovedEvent.log(new EventPair[]{this.getSessionIdField().with((Object)session.getId()), this.getModuleTypeField().with((Object)WizardStatsServiceKt.access$withSpacesRemoved(moduleType)), pluginInfoField});
        }

        /*
         * WARNING - void declaration
         */
        public final void logDataOnProjectGenerated(@Nullable WizardLoggingSession session, @Nullable Project project2, @NotNull ProjectCreationStats projectCreationStats, @NotNull UiEditorUsageStats uiEditorUsageStats) {
            void $this$orEmpty$iv;
            EventPair[] eventPairArray;
            Intrinsics.checkNotNullParameter((Object)projectCreationStats, (String)"projectCreationStats");
            Intrinsics.checkNotNullParameter((Object)uiEditorUsageStats, (String)"uiEditorUsageStats");
            VarargEventId varargEventId = projectCreatedEvent;
            Project project3 = project2;
            SpreadBuilder spreadBuilder = new SpreadBuilder(4);
            Object $this$toTypedArray$iv = projectCreationStats.toPairs();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray2 = thisCollection$iv.toArray(new EventPair[0]);
            Intrinsics.checkNotNull((Object)eventPairArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            spreadBuilder.addSpread((Object)eventPairArray2);
            $this$toTypedArray$iv = uiEditorUsageStats.toPairs();
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray3 = thisCollection$iv.toArray(new EventPair[0]);
            Intrinsics.checkNotNull((Object)eventPairArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            spreadBuilder.addSpread((Object)eventPairArray3);
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            SpreadBuilder spreadBuilder3 = spreadBuilder;
            WizardLoggingSession wizardLoggingSession = session;
            if (wizardLoggingSession != null) {
                void it;
                Object $i$f$toTypedArray2 = $this$toTypedArray$iv = wizardLoggingSession;
                SpreadBuilder spreadBuilder4 = spreadBuilder2;
                SpreadBuilder spreadBuilder5 = spreadBuilder3;
                Project project4 = project3;
                VarargEventId varargEventId2 = varargEventId;
                boolean bl = false;
                EventPair[] eventPairArray4 = new EventPair[]{Companion.getSessionIdField().with((Object)it.getId())};
                varargEventId = varargEventId2;
                project3 = project4;
                spreadBuilder3 = spreadBuilder5;
                spreadBuilder2 = spreadBuilder4;
                eventPairArray = eventPairArray4;
            } else {
                eventPairArray = null;
            }
            $this$toTypedArray$iv = eventPairArray;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if (objectArray == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new EventPair[0];
            }
            spreadBuilder2.addSpread((Object)objectArray);
            spreadBuilder3.add((Object)pluginInfoField);
            varargEventId.log(project3, (EventPair[])spreadBuilder3.toArray((Object[])new EventPair[spreadBuilder3.size()]));
        }

        public final void logUsedModuleTemplatesOnNewWizardProjectCreated(@NotNull WizardLoggingSession session, @Nullable Project project2, @NotNull String projectTemplateId, @NotNull List<String> moduleTemplates) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)projectTemplateId, (String)"projectTemplateId");
            Intrinsics.checkNotNullParameter(moduleTemplates, (String)"moduleTemplates");
            Iterable $this$forEach$iv = moduleTemplates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String moduleTemplateId = (String)element$iv;
                boolean bl = false;
                Companion.logModuleTemplateCreation(session, project2, projectTemplateId, moduleTemplateId);
            }
        }

        public final void logWizardOpenByHyperlink(@NotNull WizardLoggingSession session, @Nullable Project project2, @Nullable String templateId) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            VarargEventId varargEventId = projectOpenedByHyperlinkEvent;
            EventPair[] eventPairArray = new EventPair[3];
            StringEventField stringEventField = this.getProjectTemplateField();
            String string = templateId;
            if (string == null) {
                string = "none";
            }
            eventPairArray[0] = stringEventField.with((Object)string);
            eventPairArray[1] = this.getSessionIdField().with((Object)session.getId());
            eventPairArray[2] = pluginInfoField;
            varargEventId.log(project2, eventPairArray);
        }

        private final void logModuleTemplateCreation(WizardLoggingSession session, Project project2, String projectTemplateId, String moduleTemplateId) {
            moduleTemplateCreatedEvent.log(project2, new EventPair[]{this.getProjectTemplateField().with((Object)projectTemplateId), this.getModuleTemplateField().with((Object)moduleTemplateId), this.getSessionIdField().with((Object)session.getId()), pluginInfoField});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

