/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.ToolkitProvider;

public class AWT {
    private static final String ROOT_FRAME_CLASSNAME = SwingUtilities.class.getName() + "$";
    private static final ToolkitProvider TOOLKIT_PROVIDER = ToolkitProvider.instance();

    @RunsInCurrentThread
    public static boolean isPointInScreenBoundaries(@Nonnull JComponent c, @Nonnull Point p) {
        Point where = AWT.translate(c, p.x, p.y);
        return AWT.isPointInScreenBoundaries(where);
    }

    public static boolean isPointInScreenBoundaries(@Nonnull Point p) {
        for (GraphicsDevice screen : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            for (GraphicsConfiguration conf : screen.getConfigurations()) {
                if (!conf.getBounds().contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @RunsInCurrentThread
    public static Point translate(@Nonnull Component c, int x, int y) {
        Point p = AWT.locationOnScreenOf(c);
        if (p == null) {
            return null;
        }
        p.translate(x, y);
        return p;
    }

    @Nonnull
    @RunsInEDT
    public static Point visibleCenterOf(@Nonnull Component c) {
        Point center = GuiActionRunner.execute(() -> {
            if (c instanceof JComponent) {
                return AWT.centerOfVisibleRect((JComponent)c);
            }
            return AWT.centerOf(c);
        });
        return Preconditions.checkNotNull(center);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Component c) {
        Dimension size = c.getSize();
        return new Point(size.width / 2, size.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOfVisibleRect(@Nonnull JComponent c) {
        Rectangle r = c.getVisibleRect();
        return AWT.centerOf(Preconditions.checkNotNull(r));
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Insets insetsFrom(@Nonnull Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    public static boolean isAppletViewer(@Nullable Component c) {
        return c != null && "sun.applet.AppletViewer".equals(c.getClass().getName());
    }

    public static boolean isSharedInvisibleFrame(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    @RunsInCurrentThread
    public static boolean isHeavyWeightPopup(@Nonnull Component c) {
        if (!(c instanceof Window) || c instanceof Dialog || c instanceof Frame) {
            return false;
        }
        String name = AWT.obtainNameSafely(c);
        if ("###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name)) {
            return true;
        }
        String typeName = c.getClass().getName();
        return typeName.contains("PopupFactory$WindowPopup") || typeName.contains("HeavyWeightWindow");
    }

    @Nullable
    @RunsInCurrentThread
    private static String obtainNameSafely(@Nonnull Component c) {
        try {
            return c.getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    @RunsInCurrentThread
    public static Component invokerOf(@Nonnull Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        return parent != null ? AWT.invokerOf(parent) : null;
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point locationOnScreenOf(@Nonnull Component c) {
        return new Point(c.getLocationOnScreen());
    }

    public static boolean popupOnPress() {
        return !Platform.isWindows();
    }

    public static int popupMask() {
        return 4;
    }

    private AWT() {
    }
}

