/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.ReflectionUtilRt;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;

public class MavenLeakDetector {
    private final IdentityHashMap<Thread, Thread> markedHooks = new IdentityHashMap();

    public MavenLeakDetector mark() {
        this.markShutdownHooks();
        return this;
    }

    private void markShutdownHooks() {
        this.markedHooks.putAll(MavenLeakDetector.getShutdownHooks());
    }

    public void check() throws RemoteException {
        this.checkShutdownHooks();
    }

    private void checkShutdownHooks() throws RemoteException {
        IdentityHashMap<Thread, Thread> checkedHooks = new IdentityHashMap<Thread, Thread>(MavenLeakDetector.getShutdownHooks());
        for (Thread t : this.markedHooks.values()) {
            checkedHooks.remove(t);
        }
        for (Thread t : checkedHooks.values()) {
            MavenLeakDetector.removeHook(t);
        }
    }

    private static void removeHook(Thread thread) throws RemoteException {
        Runtime.getRuntime().removeShutdownHook(thread);
        Maven3ServerGlobals.getLogger().print(String.format("ShutdownHook[%s] was removed to avoid memory leak", thread));
    }

    private static Map<Thread, Thread> getShutdownHooks() {
        try {
            Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
            return (Map)ReflectionUtilRt.getField(clazz, null, Map.class, (String)"hooks");
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }
}

