/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    @Override
    protected void tearDown() throws Exception {
        myWrapper = null;
        super.tearDown();
    }

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    private static void doTestFor(@NotNull String testName2, @NotNull QuickFixTestCase quickFixTestCase) {
        if (testName2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(0);
        }
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(1);
        }
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/before" + testName2;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)StandardCharsets.UTF_8));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                ActionHint actionHint = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                quickFixTestCase.beforeActionStarted(testName2, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(actionHint, testFullPath, testName2);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName2, contents);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError(testName2 + " failed", e);
            }
        }, "", (Object)"");
    }

    protected void afterActionCompleted(String testName2, String contents) {
    }

    protected void beforeActionStarted(String testName2, String contents) {
    }

    public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2, @NotNull QuickFixTestCase quickFix) throws Exception {
        IntentionAction action2;
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(2);
        }
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(3);
        }
        if (testName2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(4);
        }
        if (quickFix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(5);
        }
        if ((action2 = actionHint.findAndCheck(quickFix.getAvailableActions(), () -> this.getTestInfo(testFullPath, quickFix))) != null) {
            IntentionAction afterAction;
            String text = action2.getText();
            quickFix.invoke(action2);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/after" + testName2;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
            String familyName = action2.getFamilyName();
            if (StringUtil.isEmptyOrSpaces((String)familyName)) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' provides empty family name which means that user would see action with empty presentable text in Inspection Results"));
            }
        }
    }

    private String getTestInfo(@NotNull String testFullPath, @NotNull QuickFixTestCase quickFix) {
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(6);
        }
        if (quickFix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(7);
        }
        String infos = LightQuickFixTestCase.getCurrentHighlightingInfo(quickFix.doHighlighting());
        return "Test: " + testFullPath + "\nLanguage level: " + PsiUtil.getLanguageLevel((Project)quickFix.getProject()) + "\n" + (String)(quickFix.getProject().equals(this.getProject()) ? "SDK: " + ModuleRootManager.getInstance((Module)this.getModule()).getSdk() + "\n" : "") + "Infos: " + infos;
    }

    static String getCurrentHighlightingInfo(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(8);
        }
        return ((StreamEx)StreamEx.of(infos).filter(info -> info.getSeverity() != HighlightInfoType.SYMBOL_TYPE_SEVERITY)).map(info -> {
            String fixes = "";
            if (info.quickFixActionRanges != null) {
                fixes = StreamEx.of((Collection)info.quickFixActionRanges).map(p -> p.getSecond() + " " + p.getFirst()).mapLastOrElse("|- "::concat, "\\- "::concat).map(str -> "        " + str + "\n").joining();
            }
            return info.getSeverity() + ": (" + info.getStartOffset() + "," + info.getEndOffset() + ") '" + info.getText() + "': " + info.getDescription() + "\n" + fixes;
        }).joining((CharSequence)"       ");
    }

    protected void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2) throws Exception {
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(9);
        }
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(10);
        }
        if (testName2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(11);
        }
        this.doAction(actionHint, testFullPath, testName2, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        if (actionName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(12);
        }
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action2 = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available), (Object)action2);
        this.invoke(action2);
    }

    protected void invoke(@NotNull IntentionAction action2) throws IncorrectOperationException {
        if (action2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(13);
        }
        CodeInsightTestFixtureImpl.invokeIntention(action2, this.getFile(), this.getEditor());
    }

    protected IntentionAction findActionAndCheck(@NotNull ActionHint hint, String testFullPath) {
        if (hint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(14);
        }
        return hint.findAndCheck(this.getAvailableActions(), () -> "Test: " + testFullPath);
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(15);
        }
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<? extends IntentionAction> actions, @NotNull String text) {
        if (actions == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(16);
        }
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(17);
        }
        for (IntentionAction intentionAction : actions) {
            if (!text.equals(intentionAction.getText())) continue;
            return intentionAction;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase2) {
        File[] files;
        for (File file2 : files = LightQuickFixTestCase.getBeforeTestFiles(testCase2)) {
            String testName2 = file2.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName2, testCase2);
        }
    }

    public static File @NotNull [] getBeforeTestFiles(@NotNull QuickFixTestCase testCase2) {
        if (testCase2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(18);
        }
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase2.getBasePath());
        String testDirPath = testCase2.getTestDataPath().replace(File.separatorChar, '/') + testCase2.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        if (files == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(19);
        }
        return files;
    }

    protected void doSingleTest(@NotNull String fileSuffix) {
        if (fileSuffix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(20);
        }
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected ActionHint parseActionHintImpl(@NotNull PsiFile file2, @NotNull String contents) {
        if (file2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(21);
        }
        if (contents == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(22);
        }
        return ActionHint.parse(file2, contents);
    }

    @NotNull
    protected QuickFixTestCase createWrapper() {
        QuickFixTestCase quickFixTestCase = this.createWrapper(null);
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(23);
        }
        return quickFixTestCase;
    }

    @NotNull
    protected QuickFixTestCase createWrapper(final String testDataPath) {
        return new QuickFixTestCase(){
            String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            @NotNull
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                String string = this.myTestDataPath;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public ActionHint parseActionHintImpl(@NotNull PsiFile file2, @NotNull String contents) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(2);
                }
                ActionHint actionHint = LightQuickFixTestCase.this.parseActionHintImpl(file2, contents);
                if (actionHint == null) {
                    1.$$$reportNull$$$0(3);
                }
                return actionHint;
            }

            @Override
            public void beforeActionStarted(@NotNull String testName2, @NotNull String contents) {
                if (testName2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(5);
                }
                LightQuickFixTestCase.this.beforeActionStarted(testName2, contents);
            }

            @Override
            public void afterActionCompleted(@NotNull String testName2, @NotNull String contents) {
                if (testName2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(7);
                }
                LightQuickFixTestCase.this.afterActionCompleted(testName2, contents);
            }

            @Override
            public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName2) throws Exception {
                if (actionHint == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (testFullPath == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (testName2 == null) {
                    1.$$$reportNull$$$0(10);
                }
                LightQuickFixTestCase.this.doAction(actionHint, testFullPath, testName2);
            }

            @Override
            public void checkResultByFile(@NotNull String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
                if (message == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (expectedFilePath == null) {
                    1.$$$reportNull$$$0(12);
                }
                LightQuickFixTestCase.this.checkResultByFile(message, expectedFilePath, ignoreTrailingSpaces);
            }

            @Override
            public IntentionAction findActionWithText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(13);
                }
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(@NotNull IntentionAction action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(14);
                }
                LightQuickFixTestCase.this.invoke(action2);
            }

            @Override
            @NotNull
            public List<HighlightInfo> doHighlighting() {
                List list = LightQuickFixTestCase.this.doHighlighting();
                if (list == null) {
                    1.$$$reportNull$$$0(15);
                }
                return list;
            }

            @Override
            @NotNull
            public List<IntentionAction> getAvailableActions() {
                List<IntentionAction> list = LightQuickFixTestCase.this.getAvailableActions();
                if (list == null) {
                    1.$$$reportNull$$$0(16);
                }
                return list;
            }

            @Override
            public void configureFromFileText(@NotNull String name, @NotNull String contents) {
                if (name == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(18);
                }
                LightQuickFixTestCase.this.configureFromFileText(name, contents, true);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.this.getFile();
            }

            @Override
            public Project getProject() {
                return LightQuickFixTestCase.this.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.this.bringRealEditorBack();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contents";
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testName";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionHint";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testFullPath";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedFilePath";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestDataPath";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseActionHintImpl";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doHighlighting";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAvailableActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "parseActionHintImpl";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeActionStarted";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "afterActionCompleted";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "doAction";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "checkResultByFile";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "findActionWithText";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 17: 
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "configureFromFileText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(this.getEditor(), this.getFile());
    }

    @NotNull
    public static List<IntentionAction> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(25);
        }
        List<IntentionAction> list = CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file2);
        if (list == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixTestCase";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHint";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFullPath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuffix";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTestFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapper";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTestFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHighlightingInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findActionAndCheck";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findActionWithText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeTestFiles";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doSingleTest";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseActionHintImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

