/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.junit.Assert;

public final class FindManagerTestUtils {
    public static void runFindInCommentsAndLiterals(FindManager findManager, FindModel findModel, String text) {
        FindManagerTestUtils.runFindInCommentsAndLiterals(findManager, findModel, text, "java");
    }

    public static void runFindInCommentsAndLiterals(FindManager findManager, FindModel findModel, String text, String ext) {
        findModel.setSearchContext(FindModel.SearchContext.IN_STRING_LITERALS);
        FindManagerTestUtils.runFindForwardAndBackward(findManager, findModel, text, ext);
        findModel.setSearchContext(FindModel.SearchContext.IN_COMMENTS);
        FindManagerTestUtils.runFindForwardAndBackward(findManager, findModel, text, ext);
    }

    public static void runFindForwardAndBackward(FindManager findManager, FindModel findModel, String text) {
        FindManagerTestUtils.runFindForwardAndBackward(findManager, findModel, text, "java");
    }

    public static void runFindForwardAndBackward(FindManager findManager, FindModel findModel, String text, String ext) {
        findModel.setForward(true);
        LightVirtualFile file2 = new LightVirtualFile("A." + ext, (CharSequence)text);
        FindResult findResult = findManager.findString((CharSequence)text, 0, findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        int previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text, findResult.getEndOffset(), findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((findResult.getStartOffset() > previousOffset ? 1 : 0) != 0);
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text, findResult.getEndOffset(), findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((findResult.getStartOffset() > previousOffset ? 1 : 0) != 0);
        findModel.setForward(false);
        findResult = findManager.findString((CharSequence)text, text.length(), findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text, previousOffset, findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((previousOffset > findResult.getStartOffset() ? 1 : 0) != 0);
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text, previousOffset, findModel, (VirtualFile)file2);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((previousOffset > findResult.getStartOffset() ? 1 : 0) != 0);
    }

    public static FindModel configureFindModel(String stringToFind) {
        FindModel findModel = new FindModel();
        findModel.setStringToFind(stringToFind);
        findModel.setWholeWordsOnly(false);
        findModel.setFromCursor(false);
        findModel.setGlobal(true);
        findModel.setMultipleFiles(false);
        findModel.setProjectScope(true);
        return findModel;
    }
}

