/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassResolver;", "", "()V", "COMPONENT_FUNCTION_NAME_PREFIX", "", "createComponentName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "getComponentIndex", "componentName", "isComponentLike", "", "name", "isCopy", "frontend.common"})
public final class DataClassResolver {
    @NotNull
    public static final DataClassResolver INSTANCE = new DataClassResolver();
    @NotNull
    private static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";

    private DataClassResolver() {
    }

    @NotNull
    public final Name createComponentName(int index) {
        Name name = Name.identifier(COMPONENT_FUNCTION_NAME_PREFIX + index);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(COMPONENT_FUNCTION_NAME_PREFIX + index)");
        return name;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        String string = componentName.substring(COMPONENT_FUNCTION_NAME_PREFIX.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return Integer.parseInt(string);
    }

    public final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.asString()");
        return this.isComponentLike(string);
    }

    private final boolean isComponentLike(String name) {
        if (!StringsKt.startsWith$default((String)name, (String)COMPONENT_FUNCTION_NAME_PREFIX, (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public final boolean isCopy(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)StandardNames.DATA_CLASS_COPY);
    }
}

