/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.WarningAwareUpperBoundChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.AbstractNullabilityChecker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.NotNullTypeParameter;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerStateKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J,\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J$\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002Jf\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f26\u0010 \u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\b0!H\u0002JI\u0010%\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0\u001cH\u0002\u00a2\u0006\u0002\u0010+J&\u0010,\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00061\u00b2\u0006\n\u0010)\u001a\u00020\u001dX\u008a\u0084\u0002\u00b2\u0006\n\u0010)\u001a\u00020\u001dX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkTypeParameterBounds", "doCheckType", "expectedType", "expressionTypeDataFlowValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "actualType", "doIfNotNull", "T", "", "type", "dataFlowValue", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "exactedExpressionTypeByDataFlowNullability", "findTypeParameterWithWrongBoundsNullability", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "dataFlowValueForWholeExpression", "Companion", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForEnhancedTypes = new NewKotlinTypeCheckerImpl((KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE, new KotlinTypePreparator(){

        @NotNull
        public UnwrappedType prepareType(@NotNull KotlinTypeMarker type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            UnwrappedType it = super.prepareType(type);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply((KotlinType)((KotlinType)it));
            if (kotlinType == null) {
                kotlinType = (KotlinType)it;
            }
            return kotlinType.unwrap();
        }
    });
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForBaseTypes = new NewKotlinTypeCheckerImpl((KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE, null, 2, null);

    public JavaNullabilityChecker(@NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        this.upperBoundChecker = upperBoundChecker;
    }

    @NotNull
    public final UpperBoundChecker getUpperBoundChecker() {
        return this.upperBoundChecker;
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this.checkTypeParameterBounds(expression, expressionType, c);
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataFlowValue>(c, expression, expressionType){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;
            {
                this.$c = $c;
                this.$expression = $expression;
                this.$expressionType = $expressionType;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$expression, this.$expressionType, this.$c);
            }
        }));
        TypeParameterDescriptor typeParameterDescriptor = this.findTypeParameterWithWrongBoundsNullability(expressionType, c, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda-0(this.$dataFlowValue$delegate);
            }
        }));
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            boolean bl = false;
            c.trace.report((Diagnostic)ErrorsJvm.NULLABLE_TYPE_PARAMETER_AGAINST_NOT_NULL_TYPE_PARAMETER.on((PsiElement)expression, (Object)typeParameterDescriptor2));
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"c.expectedType");
        Function0 function0 = (Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda-0(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)new Function2<KotlinType, KotlinType, Unit>(c, expression){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            {
                this.$c = $c;
                this.$expression = $expression;
                super(2);
            }

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
                Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
                this.$c.trace.report((Diagnostic)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)this.$expression, (Object)expectedType, (Object)actualType));
            }
        }));
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression).getElseExpression() == null) {
                KtExpression ktExpression2 = ((KtWhenExpression)expression).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType type = kotlinType2;
                if (FlexibleTypesKt.isFlexible((KotlinType)type) && TypeUtils.isNullableType((KotlinType)((KotlinType)FlexibleTypesKt.asFlexibleType((KotlinType)type).getUpperBound()))) {
                    ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)type);
                    if (classDescriptor == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor;
                    BindingContext bindingContext = c.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
                    BindingContext context = bindingContext;
                    if (WhenChecker.getEnumMissingCases((KtWhenExpression)((KtWhenExpression)expression), (BindingContext)context, (ClassDescriptor)enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression, context)) {
                        DataFlowInfo dataFlowInfo2;
                        DataFlowValue subjectDataFlowValue = c.dataFlowValueFactory.createDataFlowValue(subjectExpression, type, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)subjectExpression);
                        Object object = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace = c.trace;
                        KtExpression ktExpression3 = ((KtWhenExpression)expression).getSubjectExpression();
                        Intrinsics.checkNotNull((Object)ktExpression3);
                        bindingTrace.report((Diagnostic)ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((PsiElement)ktExpression3));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual((Object)((KtPostfixExpression)expression).getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL))) {
                KtExpression ktExpression4 = ((KtPostfixExpression)expression).getBaseExpression();
                if (ktExpression4 == null) {
                    return;
                }
                KtExpression baseExpression = ktExpression4;
                KotlinType kotlinType3 = c.trace.getType(baseExpression);
                if (kotlinType3 == null) {
                    return;
                }
                KotlinType baseExpressionType = kotlinType3;
                this.doIfNotNull(baseExpressionType, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>(c, baseExpression, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $baseExpression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$baseExpression = $baseExpression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    @NotNull
                    public final DataFlowValue invoke() {
                        return this.$c.dataFlowValueFactory.createDataFlowValue(this.$baseExpression, this.$baseExpressionType, this.$c);
                    }
                }), c, (Function0)new Function0<Unit>(c, expression, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$expression = $expression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    public final void invoke() {
                        this.$c.trace.report((Diagnostic)Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)((KtPostfixExpression)this.$expression).getOperationReference(), (Object)this.$baseExpressionType));
                    }
                });
            }
        } else if (ktExpression instanceof KtBinaryExpression && (((Intrinsics.areEqual((Object)(iElementType = ((KtBinaryExpression)expression).getOperationToken()), (Object)((Object)KtTokens.EQEQ)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) && ((KtBinaryExpression)expression).getLeft() != null && ((KtBinaryExpression)expression).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression;
            KtExpression ktExpression5 = ((KtBinaryExpression)expression).getLeft();
            Intrinsics.checkNotNull((Object)ktExpression5);
            KtExpression ktExpression6 = ((KtBinaryExpression)expression).getRight();
            Intrinsics.checkNotNull((Object)ktExpression6);
            SenselessComparisonChecker.checkSenselessComparisonWithNull((KtBinaryExpression)ktBinaryExpression, (KtExpression)ktExpression5, (KtExpression)ktExpression6, c, (Function1)((Function1)new Function1<KtExpression, KotlinType>(c){
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                @Nullable
                public final KotlinType invoke(@NotNull KtExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$c.trace.getType(it);
                }
            }), (Function1)((Function1)new Function1<DataFlowValue, Nullability>(this, c){
                final /* synthetic */ JavaNullabilityChecker this$0;
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    super(1);
                }

                @NotNull
                public final Nullability invoke(@NotNull DataFlowValue value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    Nullability nullability = (Nullability)JavaNullabilityChecker.access$doIfNotNull(this.this$0, value2.getType(), (Function0)new Function0<DataFlowValue>(value2){
                        final /* synthetic */ DataFlowValue $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final DataFlowValue invoke() {
                            return this.$value;
                        }
                    }, this.$c, checkType.2.INSTANCE);
                    if (nullability == null) {
                        nullability = Nullability.UNKNOWN;
                    }
                    return nullability;
                }
            }));
        }
    }

    private final void checkTypeParameterBounds(KtExpression expression, KotlinType expressionType, ResolutionContext<?> c) {
        if (expressionType instanceof AbbreviatedType) {
            KotlinType kotlinType = (KotlinType)((AbbreviatedType)expressionType).getExpandedType();
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"c.trace");
            this.upperBoundChecker.checkBoundsOfExpandedTypeAlias(kotlinType, expression, bindingTrace);
        }
        if (!(this.upperBoundChecker instanceof WarningAwareUpperBoundChecker)) {
            return;
        }
        BasicCallResolutionContext basicCallResolutionContext = c instanceof BasicCallResolutionContext ? (BasicCallResolutionContext)c : null;
        if (basicCallResolutionContext == null || (basicCallResolutionContext = basicCallResolutionContext.call) == null) {
            KtCallExpression ktCallExpression = expression instanceof KtCallExpression ? (KtCallExpression)expression : null;
            basicCallResolutionContext = (Call)c.trace.getBindingContext().get((ReadOnlySlice)BindingContext.CALL, (Object)(ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null));
            if (basicCallResolutionContext == null) {
                return;
            }
        }
        BasicCallResolutionContext call = basicCallResolutionContext;
        ResolvedCall resolvedCall = (ResolvedCall)c.trace.getBindingContext().get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call);
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Iterable typeArguments = resolvedCall2 instanceof NewResolvedCallImpl ? (Iterable)((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getTypeArgumentMappingByOriginal() : (Iterable)resolvedCall2.getTypeArguments().entrySet();
        for (Map.Entry entry : typeArguments) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)entry.getKey();
            KotlinType typeArgument = (KotlinType)entry.getValue();
            List list = call.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.typeArguments");
            KtModifierListOwnerStub ktModifierListOwnerStub = (KtTypeProjection)CollectionsKt.getOrNull((List)list, (int)typeParameter.getIndex());
            if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
            KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
            if (typeArgument == null) continue;
            WarningAwareUpperBoundChecker warningAwareUpperBoundChecker = (WarningAwareUpperBoundChecker)this.upperBoundChecker;
            TypeSubstitutor typeSubstitutor = TypeSubstitutor.create((KotlinType)typeArgument);
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor, (String)"create(typeArgument)");
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"c.trace");
            WarningAwareUpperBoundChecker.checkBounds$default(warningAwareUpperBoundChecker, (KtTypeReference)typeReference, typeArgument, typeParameter, typeSubstitutor, bindingTrace, null, true, null, 160, null);
        }
    }

    private final TypeParameterDescriptor findTypeParameterWithWrongBoundsNullability(KotlinType expressionType, ResolutionContext<?> c, Function0<DataFlowValue> dataFlowValueForWholeExpression) {
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUsingNullableTypeParameterAgainstNotNullAnnotated)) {
            return null;
        }
        if (TypeUtils.noExpectedType((KotlinType)c.expectedType)) {
            return null;
        }
        Ref.ObjectRef foundSubtypeTypeParameter = new Ref.ObjectRef();
        TypeCheckerState typeState2 = (TypeCheckerState)new ClassicTypeCheckerState(c, dataFlowValueForWholeExpression, (Ref.ObjectRef<TypeParameterDescriptor>)foundSubtypeTypeParameter){
            private boolean expectsTypeArgument;
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ Function0<DataFlowValue> $dataFlowValueForWholeExpression;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $foundSubtypeTypeParameter;
            {
                this.$c = $c;
                this.$dataFlowValueForWholeExpression = $dataFlowValueForWholeExpression;
                this.$foundSubtypeTypeParameter = $foundSubtypeTypeParameter;
                super(true, false, null, null, null, 30, null);
            }

            public boolean customIsSubtypeOf(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2) {
                Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
                Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
                if (JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter((KotlinType)subType, (KotlinType)superType2) && (this.expectsTypeArgument || this.$c.dataFlowInfo.getStableNullability((DataFlowValue)this.$dataFlowValueForWholeExpression.invoke()) != Nullability.NOT_NULL)) {
                    ClassifierDescriptor classifierDescriptor = ((KotlinType)subType).getConstructor().getDeclarationDescriptor();
                    this.$foundSubtypeTypeParameter.element = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                    return false;
                }
                if (!this.expectsTypeArgument) {
                    this.expectsTypeArgument = true;
                }
                return true;
            }
        };
        KotlinTypeMarker kotlinTypeMarker = (KotlinTypeMarker)expressionType;
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"c.expectedType");
        AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeState2, kotlinTypeMarker, (KotlinTypeMarker)kotlinType, false, 8, null);
        return (TypeParameterDescriptor)foundSubtypeTypeParameter.element;
    }

    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkNotNullParameter((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataFlowValue>(c, receiverArgument){
            final /* synthetic */ CallResolutionContext<?> $c;
            final /* synthetic */ ReceiverValue $receiverArgument;
            {
                this.$c = $c;
                this.$receiverArgument = $receiverArgument;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$receiverArgument, (ResolutionContext)this.$c);
            }
        }));
        if (safeAccess) {
            ASTNode aSTNode = c.call.getCallOperationNode();
            Object object = aSTNode != null ? aSTNode.getPsi() : null;
            if (object == null) {
                return;
            }
            PsiElement safeAccessElement = object;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiverArgument.type");
            this.doIfNotNull(kotlinType, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
                final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
                {
                    this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                    super(0);
                }

                @NotNull
                public final DataFlowValue invoke() {
                    return JavaNullabilityChecker.access$checkReceiver$lambda-2(this.$dataFlowValue$delegate);
                }
            }), (ResolutionContext)c, (Function0)new Function0<Unit>(c, safeAccessElement, receiverArgument){
                final /* synthetic */ CallResolutionContext<?> $c;
                final /* synthetic */ PsiElement $safeAccessElement;
                final /* synthetic */ ReceiverValue $receiverArgument;
                {
                    this.$c = $c;
                    this.$safeAccessElement = $safeAccessElement;
                    this.$receiverArgument = $receiverArgument;
                    super(0);
                }

                public final void invoke() {
                    this.$c.trace.report((Diagnostic)Errors.UNNECESSARY_SAFE_CALL.on(this.$safeAccessElement, (Object)this.$receiverArgument.getType()));
                }
            });
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiverArgument.type");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"receiverParameter.type");
        Function0 function0 = (Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkReceiver$lambda-2(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"c.dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)new Function2<KotlinType, KotlinType, Unit>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext<?> $c;
            {
                this.$receiverArgument = $receiverArgument;
                this.$c = $c;
                super(2);
            }

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                KtExpression receiverExpression;
                Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
                Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
                ReceiverValue receiverValue = this.$receiverArgument;
                ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
                KtExpression ktExpression = receiverExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (receiverExpression != null) {
                    this.$c.trace.report((Diagnostic)ErrorsJvm.RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)receiverExpression, (Object)actualType));
                } else {
                    KtExpression ktExpression2 = this.$c.call.getCalleeExpression();
                    KtElement ktElement = ktExpression2 != null ? (KtElement)ktExpression2 : this.$c.call.getCallElement();
                    Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"c.call.calleeExpression ?: c.call.callElement");
                    KtElement reportOn = ktElement;
                    this.$c.trace.report((Diagnostic)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((PsiElement)reportOn, (Object)expectedType, (Object)actualType));
                }
            }
        }));
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super KotlinType, ? super KotlinType, Unit> reportWarning) {
        if (TypeUtils.noExpectedType((KotlinType)expectedType)) {
            return;
        }
        KotlinType expressionType2 = this.exactedExpressionTypeByDataFlowNullability(expressionType, expressionTypeDataFlowValue, dataFlowInfo);
        boolean isEnhancedExpectedTypeSubtypeOfExpressionType = typeCheckerForEnhancedTypes.isSubtypeOf(expressionType2, expectedType);
        if (isEnhancedExpectedTypeSubtypeOfExpressionType) {
            return;
        }
        boolean isExpectedTypeSubtypeOfExpressionType = typeCheckerForBaseTypes.isSubtypeOf(expressionType2, expectedType);
        if (!isEnhancedExpectedTypeSubtypeOfExpressionType && isExpectedTypeSubtypeOfExpressionType) {
            reportWarning.invoke((Object)TypeWithEnhancementKt.unwrapEnhancementDeeply((KotlinType)expectedType), (Object)TypeWithEnhancementKt.unwrapEnhancementDeeply((KotlinType)expressionType2));
        }
    }

    private final KotlinType exactedExpressionTypeByDataFlowNullability(KotlinType expressionType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo) {
        boolean isNotNullByDataFlowInfo = dataFlowInfo.getStableNullability((DataFlowValue)expressionTypeDataFlowValue.invoke()) == Nullability.NOT_NULL;
        return KotlinTypeKt.isNullable((KotlinType)expressionType) && isNotNullByDataFlowInfo ? TypeUtilsKt.makeNotNullable((KotlinType)expressionType) : expressionType;
    }

    private final <T> T doIfNotNull(KotlinType type, Function0<DataFlowValue> dataFlowValue2, ResolutionContext<?> c, Function0<? extends T> body) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull(type);
        return (T)((enhancedNullabilityInfo != null ? enhancedNullabilityInfo.isFromJava() : false) && c.dataFlowInfo.getStableNullability((DataFlowValue)dataFlowValue2.invoke()).canBeNull() ? body.invoke() : null);
    }

    private static final DataFlowValue checkType$lambda-0(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    private static final DataFlowValue checkReceiver$lambda-2(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    public static final /* synthetic */ DataFlowValue access$checkType$lambda-0(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkType$lambda-0((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityChecker $this, KotlinType type, Function0 dataFlowValue2, ResolutionContext c, Function0 body) {
        return $this.doIfNotNull(type, (Function0<DataFlowValue>)dataFlowValue2, c, body);
    }

    public static final /* synthetic */ DataFlowValue access$checkReceiver$lambda-2(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkReceiver$lambda-2((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$Companion;", "", "()V", "typeCheckerForBaseTypes", "Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "getTypeCheckerForBaseTypes", "()Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "typeCheckerForEnhancedTypes", "getTypeCheckerForEnhancedTypes", "isNullableTypeAgainstNotNullTypeParameter", "", "subType", "Lorg/jetbrains/kotlin/types/KotlinType;", "superType", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForEnhancedTypes() {
            return typeCheckerForEnhancedTypes;
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForBaseTypes() {
            return typeCheckerForBaseTypes;
        }

        public final boolean isNullableTypeAgainstNotNullTypeParameter(@NotNull KotlinType subType, @NotNull KotlinType superType2) {
            Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
            Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
            if (!(superType2 instanceof NotNullTypeParameter) || subType instanceof NotNullTypeParameter) {
                return false;
            }
            return !AbstractNullabilityChecker.INSTANCE.isSubtypeOfAny(ClassicTypeCheckerStateKt.createClassicTypeCheckerState$default((boolean)true, (boolean)false, null, null, null, (int)30, null), (KotlinTypeMarker)subType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

