/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.devkit.workspaceModel.WorkspaceModelGenerator$generate$;
import com.intellij.devkit.workspaceModel.WorkspaceModelGeneratorKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.workspaceModel.codegen.CodeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/devkit/workspaceModel/WorkspaceModelGenerator;", "", "()V", "GENERATED_FOLDER_NAME", "", "createGeneratedSourceFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "generate", "", "project", "Lcom/intellij/openapi/project/Project;", "getSourceRoot", "", "intellij.devkit.workspaceModel"})
public final class WorkspaceModelGenerator {
    private static final String GENERATED_FOLDER_NAME = "gen";
    @NotNull
    public static final WorkspaceModelGenerator INSTANCE;

    public final void generate(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List<SourceFolder> acceptedSourceRoots = this.getSourceRoot(module);
        if (acceptedSourceRoots.isEmpty()) {
            WorkspaceModelGeneratorKt.access$getLOG$p().info("Acceptable module source roots not found");
            return;
        }
        Iterable $this$forEach$iv = acceptedSourceRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceFolder sourceRoot = (SourceFolder)element$iv;
            boolean bl = false;
            WriteAction.run((ThrowableRunnable)new ThrowableRunnable(sourceRoot, project, module){
                final /* synthetic */ SourceFolder $sourceRoot;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Module $module$inlined;
                {
                    this.$sourceRoot = sourceFolder;
                    this.$project$inlined = project;
                    this.$module$inlined = module;
                }

                public final void run() {
                    VirtualFile virtualFile = this.$sourceRoot.getFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"sourceRoot.file!!");
                    CodeWriter.INSTANCE.generate(this.$project$inlined, virtualFile, Registry.is((String)"workspace.model.generator.keep.unknown.fields"), (Function0<? extends VirtualFile>)((Function0)new Function0<VirtualFile>(this){
                        final /* synthetic */ generate$$inlined$forEach$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        @Nullable
                        public final VirtualFile invoke() {
                            return WorkspaceModelGenerator.access$createGeneratedSourceFolder(WorkspaceModelGenerator.INSTANCE, this.this$0.$module$inlined, this.this$0.$sourceRoot);
                        }
                    }));
                }
            });
        }
        String string = "Selected module " + module.getName();
        System.out.println((Object)string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final VirtualFile createGeneratedSourceFolder(Module module, SourceFolder sourceFolder) {
        SourceFolder existingGenFolder;
        ContentEntry contentEntry;
        ModifiableRootModel modifiableModel;
        VirtualFile generatedFolder2;
        block6: {
            SourceFolder sourceFolder2;
            int n;
            SourceFolder[] $this$firstOrNull$iv;
            ModuleRootManager moduleRootManager;
            generatedFolder2 = (VirtualFile)WriteAction.compute((ThrowableComputable)new ThrowableComputable(sourceFolder){
                final /* synthetic */ SourceFolder $sourceFolder;

                public final VirtualFile compute() {
                    VirtualFile virtualFile = this.$sourceFolder.getFile();
                    return VfsUtil.createDirectoryIfMissing((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null), (String)"gen");
                }
                {
                    this.$sourceFolder = sourceFolder;
                }
            });
            ModuleRootManager moduleRootManager2 = moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"moduleRootManager");
            ModifiableRootModel modifiableRootModel = moduleRootManager2.getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"moduleRootManager.modifiableModel");
            modifiableModel = modifiableRootModel;
            ContentEntry[] contentEntryArray = modifiableModel.getContentEntries();
            int n2 = contentEntryArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    modifiableModel.dispose();
                    return null;
                }
                ContentEntry contentEntry2 = contentEntry = contentEntryArray[n3];
                Intrinsics.checkNotNullExpressionValue((Object)contentEntry2, (String)"contentEntry");
                VirtualFile contentEntryFile = contentEntry2.getFile();
                if (contentEntryFile != null && VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)generatedFolder2, (boolean)false)) {
                    SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"contentEntry.sourceFolders");
                    $this$firstOrNull$iv = sourceFolderArray;
                    boolean $i$f$firstOrNull = false;
                    n = $this$firstOrNull$iv.length;
                    break;
                }
                ++n3;
            }
            for (int i = 0; i < n; ++i) {
                SourceFolder element$iv;
                SourceFolder it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                SourceFolder sourceFolder3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder3, (String)"it");
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder3.getJpsElement();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"it.jpsElement");
                JpsElement jpsElement = jpsModuleSourceRoot.getProperties();
                if (!(jpsElement instanceof JavaSourceRootProperties)) {
                    jpsElement = null;
                }
                JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)jpsElement;
                boolean bl2 = javaSourceRootProperties != null && javaSourceRootProperties.isForGeneratedSources() && Intrinsics.areEqual((Object)it.getFile(), (Object)generatedFolder2);
                if (!bl2) continue;
                sourceFolder2 = element$iv;
                break block6;
            }
            sourceFolder2 = existingGenFolder = null;
        }
        if (existingGenFolder != null) {
            return generatedFolder2;
        }
        JavaSourceRootProperties javaSourceRootProperties = JpsJavaExtensionService.getInstance().createSourceRootProperties("", true);
        Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootProperties, (String)"JpsJavaExtensionService.\u2026eRootProperties(\"\", true)");
        JavaSourceRootProperties properties = javaSourceRootProperties;
        JavaSourceRootType sourceFolderType = sourceFolder.isTestSource() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        contentEntry.addSourceFolder(generatedFolder2, (JpsModuleSourceRootType)sourceFolderType, (JpsElement)properties);
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable(modifiableModel, module){
            final /* synthetic */ ModifiableRootModel $modifiableModel;
            final /* synthetic */ Module $module;

            public final void run() {
                this.$modifiableModel.commit();
                this.$module.getProject().save();
            }
            {
                this.$modifiableModel = modifiableRootModel;
                this.$module = module;
            }
        });
        return generatedFolder2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SourceFolder> getSourceRoot(Module module) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        ModuleRootManager moduleRootManager;
        ModuleRootManager moduleRootManager2 = moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"moduleRootManager");
        ContentEntry[] contentEntries = moduleRootManager2.getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntries, (String)"contentEntries");
        Object $this$flatMap$iv = contentEntries;
        boolean $i$f$flatMap = false;
        ContentEntry[] contentEntryArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            Object[] objectArray = v1.getSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.sourceFolders");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            SourceFolder it = (SourceFolder)element$iv$iv;
            boolean bl2 = false;
            SourceFolder sourceFolder = it;
            Intrinsics.checkNotNullExpressionValue((Object)sourceFolder, (String)"it");
            if (sourceFolder.getFile() == null) {
                bl = false;
            } else {
                JavaSourceRootProperties javaSourceRootProperties;
                JpsModuleSourceRoot jpsModuleSourceRoot = it.getJpsElement();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"it.jpsElement");
                JpsElement jpsElement = jpsModuleSourceRoot.getProperties();
                if (!(jpsElement instanceof JavaSourceRootProperties)) {
                    jpsElement = null;
                }
                bl = (javaSourceRootProperties = (JavaSourceRootProperties)jpsElement) == null ? true : !javaSourceRootProperties.isForGeneratedSources();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private WorkspaceModelGenerator() {
    }

    static {
        WorkspaceModelGenerator workspaceModelGenerator;
        INSTANCE = workspaceModelGenerator = new WorkspaceModelGenerator();
    }

    public static final /* synthetic */ VirtualFile access$createGeneratedSourceFolder(WorkspaceModelGenerator $this, Module module, SourceFolder sourceFolder) {
        return $this.createGeneratedSourceFolder(module, sourceFolder);
    }
}

