/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectParentDisposableInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "sdkLink", "", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isAllowed", "intellij.devkit.core"})
public final class IncorrectParentDisposableInspection
extends DevKitUastInspectionBase {
    private final String sdkLink;

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DevKitInspectionBase.isAllowedInPluginsOnly(holder.getFile());
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"holder.file.language");
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ IncorrectParentDisposableInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                IncorrectParentDisposableInspection.access$checkCallExpression(this.this$0, node, this.$holder);
                return true;
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        }, (Class[])new Class[]{UCallExpression.class}, (boolean)false, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallExpression(UCallExpression node, ProblemsHolder holder) {
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        if (Intrinsics.areEqual((Object)psiMethod2.getName(), (Object)"isDisposed")) {
            return;
        }
        JvmParameter[] jvmParameterArray = psiMethod2.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"psiMethod.parameters");
        JvmParameter[] $this$forEachIndexed$iv = jvmParameterArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (JvmParameter item$iv : $this$forEachIndexed$iv) {
            PsiElement argumentSourcePsi;
            String typeName;
            Project project;
            PsiClassType psiClassType;
            UExpression argument;
            PsiClassType psiClassType2;
            void parameter;
            int n = index$iv++;
            JvmParameter jvmParameter = item$iv;
            int index = n;
            boolean bl = false;
            void v3 = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"parameter");
            JvmType jvmType = v3.getType();
            if (!(jvmType instanceof PsiClassType)) {
                jvmType = null;
            }
            if ((psiClassType2 = (PsiClassType)jvmType) == null || (psiClassType2 = psiClassType2.resolve()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"(parameter.type as? PsiC\u2026 ?: return@forEachIndexed");
            PsiClassType parameterType = psiClassType2;
            if (Intrinsics.areEqual((Object)parameterType.getQualifiedName(), (Object)Disposable.class.getName()) ^ true) continue;
            if (node.getArgumentForParameter(index) == null) {
                continue;
            }
            if (argument.getSourcePsi() == null) {
                continue;
            }
            PsiType psiType = argument.getExpressionType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
                continue;
            }
            PsiClassType argumentType = psiClassType;
            Intrinsics.checkNotNullExpressionValue((Object)argumentType.getProject(), (String)"argumentType.project");
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            String string = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Project.class.getName(), GlobalSearchScope.projectScope((Project)project)), (boolean)true) ? "Project" : (InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Application.class.getName(), GlobalSearchScope.projectScope((Project)project)), (boolean)true) ? "Application" : (typeName = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Module.class.getName(), GlobalSearchScope.projectScope((Project)project)), (boolean)true) ? "Module" : null));
            if (typeName == null) continue;
            holder.registerProblem(argumentSourcePsi, new HtmlBuilder().append(DevKitBundle.message("inspections.IncorrectParentDisposableInspection.do.not.use.as.disposable", typeName)).nbsp().append("(").appendLink(this.sdkLink, DevKitBundle.message("inspections.IncorrectParentDisposableInspection.documentation.link.title", new Object[0])).append(")").wrapWith(HtmlChunk.html()).toString(), new LocalQuickFix[0]);
        }
    }

    public IncorrectParentDisposableInspection() {
        super(UCallExpression.class);
        this.sdkLink = "https://plugins.jetbrains.com/docs/intellij/disposers.html?from=IncorrectParentDisposable#choosing-a-disposable-parent";
    }

    public static final /* synthetic */ void access$checkCallExpression(IncorrectParentDisposableInspection $this, UCallExpression node, ProblemsHolder holder) {
        $this.checkCallExpression(node, holder);
    }
}

