/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.settingsSync.FileState;
import com.intellij.util.io.PathKt;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"DELETED_FILE_MARKER", "", "getFileStateFromFileWithDeletedMarker", "Lcom/intellij/settingsSync/FileState;", "file", "Ljava/nio/file/Path;", "storageBasePath", "intellij.settingsSync"})
public final class FileStateKt {
    @NotNull
    public static final String DELETED_FILE_MARKER = "DELETED";

    @NotNull
    public static final FileState getFileStateFromFileWithDeletedMarker(@NotNull Path file, @NotNull Path storageBasePath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)storageBasePath, (String)"storageBasePath");
        byte[] bytes = PathKt.readBytes((Path)file);
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        String text = new String(bytes, charset2);
        String fileSpec = PathKt.getSystemIndependentPath((Path)PathsKt.relativeTo((Path)file, (Path)storageBasePath));
        return Intrinsics.areEqual((Object)text, (Object)DELETED_FILE_MARKER) ? (FileState)new FileState.Deleted(fileSpec) : (FileState)new FileState.Modified(fileSpec, bytes, bytes.length);
    }
}

