/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.config.SettingsSyncConfigurable;
import com.intellij.settingsSync.config.SettingsSyncStatusAction$WhenMappings;
import icons.SettingsSyncIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getStatus", "Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$SyncStatus;", "update", "SyncStatus", "intellij.settingsSync"})
public final class SettingsSyncStatusAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), SettingsSyncConfigurable.class);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation p = presentation;
        if (!SettingsSyncMainKt.isSettingsSyncEnabledByKey()) {
            p.setEnabledAndVisible(false);
            return;
        }
        switch (SettingsSyncStatusAction$WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 1: {
                p.setIcon(SettingsSyncIcons.StatusEnabled);
                p.setText(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.on", new Object[0]));
                break;
            }
            case 2: {
                p.setIcon(SettingsSyncIcons.StatusDisabled);
                p.setText(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.is.off", new Object[0]));
                break;
            }
            case 3: {
                p.setIcon(AllIcons.General.Error);
                p.setText(SettingsSyncBundle.INSTANCE.message("status.action.settings.sync.failed", new Object[0]));
            }
        }
    }

    private final SyncStatus getStatus() {
        if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled() && SettingsSyncAuthService.Companion.getInstance().isLoggedIn()) {
            return SettingsSyncStatusTracker.Companion.getInstance().isSyncSuccessful() ? SyncStatus.ON : SyncStatus.FAILED;
        }
        return SyncStatus.OFF;
    }

    public SettingsSyncStatusAction() {
        super(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncStatusAction$SyncStatus;", "", "(Ljava/lang/String;I)V", "ON", "OFF", "FAILED", "intellij.settingsSync"})
    private static final class SyncStatus
    extends Enum<SyncStatus> {
        public static final /* enum */ SyncStatus ON;
        public static final /* enum */ SyncStatus OFF;
        public static final /* enum */ SyncStatus FAILED;
        private static final /* synthetic */ SyncStatus[] $VALUES;

        static {
            SyncStatus[] syncStatusArray = new SyncStatus[3];
            SyncStatus[] syncStatusArray2 = syncStatusArray;
            syncStatusArray[0] = ON = new SyncStatus();
            syncStatusArray[1] = OFF = new SyncStatus();
            syncStatusArray[2] = FAILED = new SyncStatus();
            $VALUES = syncStatusArray;
        }

        public static SyncStatus[] values() {
            return (SyncStatus[])$VALUES.clone();
        }

        public static SyncStatus valueOf(String string) {
            return Enum.valueOf(SyncStatus.class, string);
        }
    }
}

