/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.BlockList;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final BlockList<PositionEntry> byOffset;
    private final LinkedList<BasePackBitmapIndex.StoredBitmap> bitmapsToWriteXorBuffer = new LinkedList();
    private List<StoredEntry> bitmapsToWrite = new ArrayList<StoredEntry>();
    final ObjectIdOwnerMap<PositionEntry> positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List<ObjectToPack> objects) {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.byOffset = new BlockList(objects.size());
        PackBitmapIndexBuilder.sortByOffsetAndIndex(this.byOffset, this.positionEntries, objects);
        int sizeInWords = Math.max(4, this.byOffset.size() / 64 / 3);
        this.commits = new EWAHCompressedBitmap(sizeInWords);
        this.trees = new EWAHCompressedBitmap(sizeInWords);
        this.blobs = new EWAHCompressedBitmap(sizeInWords);
        this.tags = new EWAHCompressedBitmap(sizeInWords);
        int i = 0;
        while (i < objects.size()) {
            int type = objects.get(i).getType();
            switch (type) {
                case 1: {
                    this.commits.set(i);
                    break;
                }
                case 2: {
                    this.trees.set(i);
                    break;
                }
                case 3: {
                    this.blobs.set(i);
                    break;
                }
                case 4: {
                    this.tags.set(i);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(type)));
                }
            }
            ++i;
        }
        this.commits.trim();
        this.trees.trim();
        this.blobs.trim();
        this.tags.trim();
    }

    private static void sortByOffsetAndIndex(BlockList<PositionEntry> byOffset, ObjectIdOwnerMap<PositionEntry> positionEntries, List<ObjectToPack> entries) {
        int i = 0;
        while (i < entries.size()) {
            positionEntries.add(new PositionEntry(entries.get(i), i));
            ++i;
        }
        Collections.sort(entries, (a, b) -> Long.signum(a.getOffset() - b.getOffset()));
        i = 0;
        while (i < entries.size()) {
            PositionEntry e = positionEntries.get(entries.get(i));
            e.offsetPosition = i++;
            byOffset.add(e);
        }
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() {
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        for (PositionEntry e : this.byOffset) {
            r.add(new ObjectIdOwnerMap.Entry(e){});
        }
        return r;
    }

    public void addBitmap(AnyObjectId objectId, BitmapIndex.Bitmap bitmap, int flags) {
        this.addBitmap(objectId, bitmap.retrieveCompressed(), flags);
    }

    public void processBitmapForWrite(BitmapCommit c, BitmapIndex.Bitmap bitmap, int flags) {
        EWAHCompressedBitmap compressed = bitmap.retrieveCompressed();
        compressed.trim();
        BasePackBitmapIndex.StoredBitmap newest = new BasePackBitmapIndex.StoredBitmap(c, compressed, null, flags);
        this.bitmapsToWriteXorBuffer.add(newest);
        if (this.bitmapsToWriteXorBuffer.size() > 10) {
            this.bitmapsToWrite.add(this.generateStoredEntry(this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        if (c.isAddToIndex()) {
            this.addBitmap((AnyObjectId)c, bitmap, flags);
        }
    }

    private StoredEntry generateStoredEntry(BasePackBitmapIndex.StoredBitmap bitmapToWrite) {
        int bestXorOffset = 0;
        EWAHCompressedBitmap bestBitmap = bitmapToWrite.getBitmap();
        int offset = 1;
        for (BasePackBitmapIndex.StoredBitmap curr : this.bitmapsToWriteXorBuffer) {
            EWAHCompressedBitmap bitmap = curr.getBitmap().xor(bitmapToWrite.getBitmap());
            if (bitmap.sizeInBytes() < bestBitmap.sizeInBytes()) {
                bestBitmap = bitmap;
                bestXorOffset = offset;
            }
            ++offset;
        }
        PositionEntry entry = this.positionEntries.get(bitmapToWrite);
        if (entry == null) {
            throw new IllegalStateException();
        }
        bestBitmap.trim();
        StoredEntry result2 = new StoredEntry(entry.namePosition, bestBitmap, bestXorOffset, bitmapToWrite.getFlags());
        return result2;
    }

    public void addBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, int flags) {
        bitmap.trim();
        BasePackBitmapIndex.StoredBitmap result2 = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, null, flags);
        this.getBitmaps().add(result2);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type) {
        switch (type) {
            case 3: {
                return this.getBlobs().and(bitmap);
            }
            case 2: {
                return this.getTrees().and(bitmap);
            }
            case 1: {
                return this.getCommits().and(bitmap);
            }
            case 4: {
                return this.getTags().and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        PositionEntry entry = this.positionEntries.get(objectId);
        if (entry == null) {
            return -1;
        }
        return entry.offsetPosition;
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.byOffset.get(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    @Override
    public int getBitmapCount() {
        return this.bitmapsToWriteXorBuffer.size() + this.bitmapsToWrite.size();
    }

    public void resetBitmaps(int size) {
        this.getBitmaps().clear();
        this.bitmapsToWrite = new ArrayList<StoredEntry>(size);
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.size();
    }

    public List<StoredEntry> getCompressedBitmaps() {
        while (!this.bitmapsToWriteXorBuffer.isEmpty()) {
            this.bitmapsToWrite.add(this.generateStoredEntry(this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        Collections.reverse(this.bitmapsToWrite);
        return this.bitmapsToWrite;
    }

    private static final class PositionEntry
    extends ObjectIdOwnerMap.Entry {
        final int namePosition;
        int offsetPosition;

        PositionEntry(AnyObjectId objectId, int namePosition) {
            super(objectId);
            this.namePosition = namePosition;
        }
    }

    public static final class StoredEntry {
        private final long objectId;
        private final EWAHCompressedBitmap bitmap;
        private final int xorOffset;
        private final int flags;

        StoredEntry(long objectId, EWAHCompressedBitmap bitmap, int xorOffset, int flags) {
            this.objectId = objectId;
            this.bitmap = bitmap;
            this.xorOffset = xorOffset;
            this.flags = flags;
        }

        public EWAHCompressedBitmap getBitmap() {
            return this.bitmap;
        }

        public int getXorOffset() {
            return this.xorOffset;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getObjectId() {
            return this.objectId;
        }
    }
}

