/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.ImmutableSortedMap;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexInfrastructureVersionBase;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentEnumerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IdeSharedIndexesState {
    private static final Logger LOG = Logger.getInstance(IdeSharedIndexesState.class);
    public final List<FileBasedIndexExtension<?, ?>> exportableFileBasedIndexExtensions;
    public final List<StubIndexExtension<?, ?>> exportableStubIndexExtensions;
    private final Set<IndexInfrastructureOs> mySupportedOses = EnumSet.of(IndexInfrastructureOs.getOs());
    private final Map<IndexInfrastructureCapability, Map<String, String>> myCapabilities = new EnumMap<IndexInfrastructureCapability, Map<String, String>>(IndexInfrastructureCapability.class);
    private final List<SharedIndexContentHash> myHashProviders = new ArrayList<SharedIndexContentHash>(SharedIndexHashProviders.getSharedIndexHashingProvidersForMetadata());

    public IdeSharedIndexesState() {
        this.exportableFileBasedIndexExtensions = FileBasedIndexExtension.EXTENSION_POINT_NAME.extensions().filter(FileBasedIndexExtension::dependsOnFileContent).filter(FileBasedIndexExtension::canBeShared).filter(ex -> !(ex instanceof StubUpdatingIndex)).collect(Collectors.toList());
        this.exportableStubIndexExtensions = StubIndexExtension.EP_NAME.getExtensionList();
    }

    public IdeSharedIndexesState withSupportedOs(@NotNull Collection<IndexInfrastructureOs> osToAdd) {
        if (osToAdd == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(0);
        }
        this.mySupportedOses.addAll(osToAdd);
        return this;
    }

    public void registerCapability(@NotNull IndexInfrastructureCapability capability, @NotNull Map<String, String> versions) {
        if (capability == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(1);
        }
        if (versions == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(2);
        }
        this.myCapabilities.put(capability, versions);
    }

    public void withActualHashGeneratorVersions(@NotNull List<SharedIndexContentHash> providers) {
        if (providers == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(3);
        }
        this.myHashProviders.clear();
        this.myHashProviders.addAll(providers);
    }

    @NotNull
    public SharedIndexInfrastructureVersion getIndexVersion() {
        return new SharedIndexInfrastructureVersion(this.myCapabilities, this.mySupportedOses, IdeSharedIndexesState.getBaseIndexVersions(), IndexInfrastructureVersionBase.fileBasedIndexVersions(this.exportableFileBasedIndexExtensions, ex -> SharedIndexExtension.getFileBasedIndexVersion(ex)), IndexInfrastructureVersionBase.stubIndexVersions(this.exportableStubIndexExtensions), IndexInfrastructureVersionBase.stubFileElementTypeVersions(), IndexInfrastructureVersionBase.getAllCompositeBinaryFileStubBuilderVersions(), IdeSharedIndexesState.hashProviderVersions(this.myHashProviders));
    }

    @NotNull
    private static Map<String, String> getBaseIndexVersions() {
        if (IOUtil.isSharedCachesEnabled()) {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.set(false);
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        builder.put((Object)"shared_indexes_format", (Object)SharedIndexInfrastructureVersion.SHARED_INDEXES_VERSIONS_FORMAT_VERSION);
        builder.put((Object)"metadata_version", (Object)"7");
        builder.put((Object)"vfs_version", (Object)String.valueOf(FSRecords.getVersion()));
        builder.put((Object)"persistent_enumerator_version", (Object)String.valueOf(PersistentEnumerator.getVersion()));
        builder.put((Object)"use_btree", (Object)String.valueOf(true));
        builder.put((Object)"hashes_enumerator_version", (Object)String.valueOf(ContentHashEnumerator.getVersion()));
        builder.put((Object)"hashes_algorithm_version", (Object)String.valueOf(IndexedHashesSupport.getVersion()));
        builder.put((Object)"inverted_index_version", (Object)String.valueOf(0));
        builder.put((Object)"product_version", (Object)ApplicationInfo.getInstance().getShortVersion());
        ImmutableSortedMap immutableSortedMap = builder.build();
        ImmutableSortedMap immutableSortedMap2 = immutableSortedMap;
        if (immutableSortedMap2 == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(4);
        }
        return immutableSortedMap2;
        finally {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.remove();
        }
    }

    @NotNull
    private static Map<String, String> hashProviderVersions(@NotNull Collection<SharedIndexContentHash> providers) {
        if (providers == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(5);
        }
        HashMap<String, String> builder = new HashMap<String, String>();
        for (SharedIndexContentHash provider : providers) {
            String newValue;
            String name = provider.getProviderId();
            String oldValue = builder.put(name, newValue = provider.getVersion());
            if (oldValue == null || oldValue.equals(newValue)) continue;
            LOG.warn("Multiple declarations of the same stub based index: " + name + ", old value " + oldValue + ", new value: " + newValue);
        }
        HashMap<String, String> hashMap = builder;
        if (hashMap == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    public Set<FileType> getNoSizeLimitApplicableFileTypes() {
        Set<FileType> set = this.exportableFileBasedIndexExtensions.stream().flatMap(g -> g.getFileTypesWithSizeLimitNotApplicable().stream()).collect(Collectors.toSet());
        if (set == null) {
            IdeSharedIndexesState.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osToAdd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capability";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/IdeSharedIndexesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/IdeSharedIndexesState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndexVersions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "hashProviderVersions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoSizeLimitApplicableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withSupportedOs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerCapability";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withActualHashGeneratorVersions";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hashProviderVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

