/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenRunnerSettings
implements Cloneable {
    @NonNls
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    @NonNls
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    @NonNls
    public static final String USE_JAVA_HOME = "#JAVA_HOME";
    private boolean delegateBuildToMaven = false;
    private boolean runMavenInBackground = true;
    @NotNull
    private String jreName = "#USE_PROJECT_JDK";
    @NotNull
    private String vmOptions = "";
    private boolean skipTests = false;
    private Map<String, String> mavenProperties = new LinkedHashMap<String, String>();
    private Map<String, String> environmentProperties = new HashMap<String, String>();
    private boolean passParentEnv = true;
    private DisposableWrapperList<Listener> myListeners = new DisposableWrapperList();

    public boolean isDelegateBuildToMaven() {
        return this.delegateBuildToMaven;
    }

    public void setDelegateBuildToMaven(boolean delegateBuildToMaven) {
        this.delegateBuildToMaven = delegateBuildToMaven;
    }

    public boolean isRunMavenInBackground() {
        return this.runMavenInBackground;
    }

    public void setRunMavenInBackground(boolean runMavenInBackground) {
        this.runMavenInBackground = runMavenInBackground;
    }

    @NotNull
    @NlsSafe
    public String getJreName() {
        String string = this.jreName;
        if (string == null) {
            MavenRunnerSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setJreName(@Nullable String jreName) {
        this.jreName = Objects.requireNonNullElse(jreName, USE_PROJECT_JDK);
    }

    @NotNull
    public String getVmOptions() {
        String string = this.vmOptions;
        if (string == null) {
            MavenRunnerSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        if (vmOptions != null) {
            this.vmOptions = vmOptions;
        }
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        if (skipTests != this.skipTests) {
            this.fireSkipTestsChanged();
        }
        this.skipTests = skipTests;
    }

    public Map<String, String> getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Map<String, String> mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    @NotNull
    public Map<String, String> getEnvironmentProperties() {
        Map<String, String> map2 = this.environmentProperties;
        if (map2 == null) {
            MavenRunnerSettings.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public void setEnvironmentProperties(@NotNull Map<String, String> envs) {
        if (envs == null) {
            MavenRunnerSettings.$$$reportNull$$$0(3);
        }
        if (envs == this.environmentProperties) {
            return;
        }
        this.environmentProperties.clear();
        this.environmentProperties.putAll(envs);
    }

    public boolean isPassParentEnv() {
        return this.passParentEnv;
    }

    public void setPassParentEnv(boolean passParentEnv) {
        this.passParentEnv = passParentEnv;
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenRunnerSettings.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            MavenRunnerSettings.$$$reportNull$$$0(5);
        }
        this.myListeners.add((Object)l, disposable);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove((Object)l);
    }

    private void fireSkipTestsChanged() {
        for (Listener each : this.myListeners) {
            each.skipTestsChanged();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerSettings that = (MavenRunnerSettings)o;
        if (this.delegateBuildToMaven != that.delegateBuildToMaven) {
            return false;
        }
        if (this.runMavenInBackground != that.runMavenInBackground) {
            return false;
        }
        if (this.skipTests != that.skipTests) {
            return false;
        }
        if (!this.jreName.equals(that.jreName)) {
            return false;
        }
        if (this.mavenProperties != null ? !this.mavenProperties.equals(that.mavenProperties) : that.mavenProperties != null) {
            return false;
        }
        if (!this.vmOptions.equals(that.vmOptions)) {
            return false;
        }
        if (!this.environmentProperties.equals(that.environmentProperties)) {
            return false;
        }
        return this.passParentEnv == that.passParentEnv;
    }

    public int hashCode() {
        int result = this.delegateBuildToMaven ? 1 : 0;
        result = 31 * result + (this.runMavenInBackground ? 1 : 0);
        result = 31 * result + this.jreName.hashCode();
        result = 31 * result + this.vmOptions.hashCode();
        result = 31 * result + (this.skipTests ? 1 : 0);
        result = 31 * result + this.environmentProperties.hashCode();
        result = 31 * result + (this.mavenProperties != null ? this.mavenProperties.hashCode() : 0);
        return result;
    }

    public MavenRunnerSettings clone() {
        try {
            MavenRunnerSettings clone = (MavenRunnerSettings)super.clone();
            clone.mavenProperties = MavenRunnerSettings.cloneMap(this.mavenProperties);
            clone.myListeners = new DisposableWrapperList();
            clone.environmentProperties = new HashMap<String, String>(this.environmentProperties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static <K, V> Map<K, V> cloneMap(Map<K, V> source) {
        return new LinkedHashMap<K, V>(source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJreName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironmentProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void skipTestsChanged();
    }
}

