/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenModelUtil {
    public static final String TEST_SUFFIX = ".test";
    public static final String MAIN_SUFFIX = ".main";
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);

    @NotNull
    public static String getArtifactUrlForClassifierAndExtension(@NotNull MavenArtifact artifact, @Nullable String classifier, @Nullable String extension) {
        if (artifact == null) {
            MavenModelUtil.$$$reportNull$$$0(0);
        }
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        String string = VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
        if (string == null) {
            MavenModelUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getArtifactUrl(@NotNull MavenArtifact artifact, @NotNull MavenExtraArtifactType artifactType, @NotNull MavenProject project2) {
        if (artifact == null) {
            MavenModelUtil.$$$reportNull$$$0(2);
        }
        if (artifactType == null) {
            MavenModelUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            MavenModelUtil.$$$reportNull$$$0(4);
        }
        Pair<String, String> result = project2.getClassifierAndExtension(artifact, artifactType);
        String classifier = (String)result.first;
        String extension = (String)result.second;
        return MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, classifier, extension);
    }

    @NotNull
    public static LanguageLevel getSourceLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(5);
        }
        return MavenModelUtil.getLanguageLevel(mavenProject2, () -> MavenModelUtil.getMavenLanguageLevel(mavenProject2, MavenModelUtil.isReleaseCompilerProp(mavenProject2), true, false));
    }

    @Nullable
    public static LanguageLevel getTargetLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(6);
        }
        return MavenModelUtil.getMavenLanguageLevel(mavenProject2, MavenModelUtil.isReleaseCompilerProp(mavenProject2), false, false);
    }

    @Nullable
    public static LanguageLevel getTargetTestLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(7);
        }
        return MavenModelUtil.getMavenLanguageLevel(mavenProject2, MavenModelUtil.isReleaseCompilerProp(mavenProject2), false, true);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull MavenProject mavenProject2, @NotNull Supplier<LanguageLevel> supplier) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(8);
        }
        if (supplier == null) {
            MavenModelUtil.$$$reportNull$$$0(9);
        }
        LanguageLevel level = null;
        Element cfg = mavenProject2.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            level = MAVEN_IDEA_PLUGIN_LEVELS.get(cfg.getChildTextTrim("jdkLevel"));
        }
        if (level == null) {
            level = supplier.get();
        }
        if (level == null) {
            level = MavenModelUtil.getDefaultLevel(mavenProject2);
        }
        if (level.isAtLeast(LanguageLevel.JDK_11)) {
            level = MavenModelUtil.adjustPreviewLanguageLevel(mavenProject2, level);
        }
        LanguageLevel languageLevel2 = level;
        if (languageLevel2 == null) {
            MavenModelUtil.$$$reportNull$$$0(10);
        }
        return languageLevel2;
    }

    @NotNull
    public static MavenJavaVersionHolder getMavenJavaVersions(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(11);
        }
        boolean useReleaseCompilerProp = MavenModelUtil.isReleaseCompilerProp(mavenProject2);
        LanguageLevel sourceVersion = MavenModelUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, true, false);
        LanguageLevel sourceTestVersion = MavenModelUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, true, true);
        LanguageLevel targetVersion = MavenModelUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, false, false);
        LanguageLevel targetTestVersion = MavenModelUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, false, true);
        return new MavenJavaVersionHolder(sourceVersion, targetVersion, sourceTestVersion, targetTestVersion);
    }

    @Nullable
    private static LanguageLevel getMavenLanguageLevel(@NotNull MavenProject mavenProject2, boolean useReleaseCompilerProp, boolean isSource, boolean isTest) {
        String mavenProjectLanguageLevel;
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(12);
        }
        String mavenProjectReleaseLevel = useReleaseCompilerProp ? (isTest ? mavenProject2.getTestReleaseLevel() : mavenProject2.getReleaseLevel()) : null;
        LanguageLevel level = LanguageLevel.parse((String)mavenProjectReleaseLevel);
        if (level == null && (level = LanguageLevel.parse((String)(mavenProjectLanguageLevel = MavenModelUtil.getMavenLanguageLevel(mavenProject2, isTest, isSource)))) == null && (StringUtil.isNotEmpty((String)mavenProjectLanguageLevel) || StringUtil.isNotEmpty((String)mavenProjectReleaseLevel))) {
            level = LanguageLevel.HIGHEST;
        }
        return level;
    }

    private static String getMavenLanguageLevel(MavenProject project2, boolean test, boolean source) {
        if (test) {
            return source ? project2.getTestSourceLevel() : project2.getTestTargetLevel();
        }
        return source ? project2.getSourceLevel() : project2.getTargetLevel();
    }

    @NotNull
    public static LanguageLevel getDefaultLevel(MavenProject mavenProject2) {
        MavenPlugin plugin = mavenProject2.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        if (plugin != null && plugin.getVersion() != null) {
            if (VersionComparatorUtil.compare((String)"3.8.1", (String)plugin.getVersion()) <= 0) {
                LanguageLevel languageLevel2 = LanguageLevel.JDK_1_6;
                if (languageLevel2 == null) {
                    MavenModelUtil.$$$reportNull$$$0(13);
                }
                return languageLevel2;
            }
            LanguageLevel languageLevel3 = LanguageLevel.JDK_1_5;
            if (languageLevel3 == null) {
                MavenModelUtil.$$$reportNull$$$0(14);
            }
            return languageLevel3;
        }
        LanguageLevel languageLevel4 = LanguageLevel.JDK_1_5;
        if (languageLevel4 == null) {
            MavenModelUtil.$$$reportNull$$$0(15);
        }
        return languageLevel4;
    }

    private static LanguageLevel adjustPreviewLanguageLevel(MavenProject mavenProject2, LanguageLevel level) {
        Element compilerArgs;
        Element compilerConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        if (compilerConfiguration != null && (compilerArgs = compilerConfiguration.getChild("compilerArgs")) != null && (MavenModelUtil.isPreviewText(compilerArgs) || compilerArgs.getChildren("arg").stream().anyMatch(MavenModelUtil::isPreviewText) || compilerArgs.getChildren("compilerArg").stream().anyMatch(MavenModelUtil::isPreviewText))) {
            try {
                return LanguageLevel.valueOf((String)(level.name() + "_PREVIEW"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    private static boolean isPreviewText(Element child) {
        return "--enable-preview".equals(child.getTextTrim());
    }

    public static boolean isReleaseCompilerProp(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(16);
        }
        return StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"3.6") >= 0;
    }

    public static boolean isCompilerTestSupport(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(17);
        }
        return StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"2.1") >= 0;
    }

    public static boolean isMainOrTestSubmodule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenModelUtil.$$$reportNull$$$0(18);
        }
        return moduleName.length() > 5 && moduleName.endsWith(MAIN_SUFFIX) || moduleName.endsWith(TEST_SUFFIX);
    }

    public static boolean isMainModule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenModelUtil.$$$reportNull$$$0(19);
        }
        return moduleName.contains(MAIN_SUFFIX);
    }

    public static boolean isTestModule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenModelUtil.$$$reportNull$$$0(20);
        }
        return moduleName.contains(TEST_SUFFIX);
    }

    @NotNull
    public static String getParentModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenModelUtil.$$$reportNull$$$0(21);
        }
        if (MavenModelUtil.isMainModule(moduleName)) {
            String string = StringUtil.trimEnd((String)moduleName, (String)MAIN_SUFFIX);
            if (string == null) {
                MavenModelUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (MavenModelUtil.isTestModule(moduleName)) {
            String string = StringUtil.trimEnd((String)moduleName, (String)TEST_SUFFIX);
            if (string == null) {
                MavenModelUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = moduleName;
        if (string == null) {
            MavenModelUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getModuleName(@NotNull MavenProject mavenProject2, @NotNull Project project2) {
        MavenProjectsTree projectsTree;
        if (mavenProject2 == null) {
            MavenModelUtil.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            MavenModelUtil.$$$reportNull$$$0(26);
        }
        return (projectsTree = MavenProjectsManager.getInstance(project2).getProjectsTree()) != null ? MavenModelUtil.getModuleName(mavenProject2, projectsTree, new HashMap<MavenProject, String>()) : "";
    }

    @NotNull
    public static String getModuleName(@NotNull MavenProject project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, String> moduleNameMap) {
        String parentName;
        MavenProject parentProject;
        Object moduleName;
        if (project2 == null) {
            MavenModelUtil.$$$reportNull$$$0(27);
        }
        if (projectsTree == null) {
            MavenModelUtil.$$$reportNull$$$0(28);
        }
        if (moduleNameMap == null) {
            MavenModelUtil.$$$reportNull$$$0(29);
        }
        if ((moduleName = moduleNameMap.get(project2)) != null) {
            String string = moduleName;
            if (string == null) {
                MavenModelUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        moduleName = project2.getMavenId().getArtifactId();
        if (moduleName == null) {
            return "";
        }
        if (project2.getParentId() != null && (parentProject = projectsTree.findProject(project2.getParentId())) != null && StringUtil.isNotEmpty((String)(parentName = MavenModelUtil.getModuleName(parentProject, projectsTree, moduleNameMap)))) {
            moduleName = parentName + "." + (String)moduleName;
        }
        moduleNameMap.put(project2, (String)moduleName);
        String string = moduleName;
        if (string == null) {
            MavenModelUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenModelUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 4: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenModelUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactUrlForClassifierAndExtension";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentModuleName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrlForClassifierAndExtension";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceLanguageLevel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTestLanguageLevel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMavenJavaVersions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMavenLanguageLevel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReleaseCompilerProp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCompilerTestSupport";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMainOrTestSubmodule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMainModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTestModule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleName";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

