/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportContext;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDependencyProvider;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.ModuleData;
import org.jetbrains.idea.maven.importing.tree.SplittedMainAndTestModules;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenProjectImportContextProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final MavenProjectsTree myProjectsTree;
    @NotNull
    protected final Map<MavenId, MavenProjectChanges> myProjectsToImportWithChanges;
    @NotNull
    protected final MavenImportingSettings myImportingSettings;

    public MavenProjectImportContextProvider(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> changes, @NotNull MavenImportingSettings importingSettings) {
        if (project2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(2);
        }
        if (importingSettings == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myProjectsToImportWithChanges = changes.entrySet().stream().collect(Collectors.toMap(e -> ((MavenProject)e.getKey()).getMavenId(), e -> (MavenProjectChanges)e.getValue(), (v1, v2) -> v1));
        this.myImportingSettings = importingSettings;
    }

    public MavenModuleImportContext getContext() {
        ModuleImportDataContext importDataContext = this.getModuleImportDataContext();
        ModuleImportDataDependecyContext importDataDependencyContext = this.getFlattenModuleDataDependencyContext(importDataContext);
        return new MavenModuleImportContext(importDataDependencyContext.changedModuleDataWithDependencies, importDataDependencyContext.allModuleDataWithDependencies, importDataContext.moduleNameByProject, importDataContext.hasChanges, importDataDependencyContext.legacyCreatedModules, importDataContext.legacyObsoleteModules);
    }

    @NotNull
    private ModuleImportDataContext getModuleImportDataContext() {
        boolean hasChanges = false;
        ArrayList<MavenProjectImportData> allModules = new ArrayList<MavenProjectImportData>();
        TreeMap<MavenId, MavenProjectImportData> moduleImportDataByMavenId = new TreeMap<MavenId, MavenProjectImportData>(Comparator.comparing(MavenId::getKey));
        HashMap<MavenProject, String> moduleNameByProject = new HashMap<MavenProject, String>();
        Map<String, Module> legacyModuleByName = this.buildModuleByNameMap();
        for (MavenProject project2 : this.myProjectsTree.getProjects()) {
            if (this.myProjectsTree.isIgnored(project2)) continue;
            String moduleName = MavenModelUtil.getModuleName(project2, this.myProjectsTree, moduleNameByProject);
            if (StringUtil.isEmpty((String)moduleName)) {
                MavenLog.LOG.warn("[import context] empty module name for project " + project2);
                continue;
            }
            MavenProjectChanges changes = this.myProjectsToImportWithChanges.get(project2.getMavenId());
            MavenProjectImportData mavenProjectImportData = this.getModuleImportData(project2, moduleName, legacyModuleByName, changes);
            if (changes != null && changes.hasChanges()) {
                hasChanges = true;
            }
            moduleImportDataByMavenId.put(project2.getMavenId(), mavenProjectImportData);
            allModules.add(mavenProjectImportData);
        }
        return new ModuleImportDataContext(allModules, moduleNameByProject, moduleImportDataByMavenId, new ArrayList<Module>(legacyModuleByName.values()), hasChanges);
    }

    protected Map<String, Module> buildModuleByNameMap() {
        return Collections.emptyMap();
    }

    @NotNull
    private ModuleImportDataDependecyContext getFlattenModuleDataDependencyContext(ModuleImportDataContext context) {
        ArrayList<Module> legacyCreatedModules = new ArrayList<Module>();
        ArrayList<MavenModuleImportData> allModuleDataWithDependencies = new ArrayList<MavenModuleImportData>();
        ArrayList<MavenModuleImportData> changedModuleDataWithDependencies = new ArrayList<MavenModuleImportData>();
        MavenModuleImportDependencyProvider dependencyProvider = new MavenModuleImportDependencyProvider(this.myProject, context.moduleImportDataByMavenId, this.myImportingSettings, this.myProjectsTree);
        for (MavenProjectImportData importData : context.importData) {
            MavenModuleImportDataWithDependencies importDataWithDependencies = dependencyProvider.getDependencies(importData);
            List<MavenModuleImportData> mavenModuleImportDataList = MavenProjectImportContextProvider.splitToModules(importDataWithDependencies);
            for (MavenModuleImportData moduleImportData : mavenModuleImportDataList) {
                if (moduleImportData.hasChanges()) {
                    changedModuleDataWithDependencies.add(moduleImportData);
                }
                this.addLegacyCreatedModule(legacyCreatedModules, moduleImportData);
                allModuleDataWithDependencies.add(moduleImportData);
            }
        }
        return new ModuleImportDataDependecyContext(allModuleDataWithDependencies, changedModuleDataWithDependencies, legacyCreatedModules);
    }

    protected void addLegacyCreatedModule(List<Module> createdModules, MavenModuleImportData moduleImportData) {
    }

    @NotNull
    protected static List<MavenModuleImportData> splitToModules(MavenModuleImportDataWithDependencies dataWithDependencies) {
        SplittedMainAndTestModules mainAndTestModules = dataWithDependencies.getModuleImportData().getSplittedMainAndTestModules();
        MavenProject project2 = dataWithDependencies.getModuleImportData().getMavenProject();
        ModuleData moduleData = dataWithDependencies.getModuleImportData().getModuleData();
        MavenProjectChanges changes = dataWithDependencies.getModuleImportData().getChanges();
        if (mainAndTestModules != null) {
            ArrayList<MavenModuleImportData> result = new ArrayList<MavenModuleImportData>(3);
            result.add(new MavenModuleImportData(project2, moduleData, Collections.emptyList(), dataWithDependencies.getModuleImportData().getChanges()));
            result.add(new MavenModuleImportData(project2, mainAndTestModules.getMainData(), dataWithDependencies.getMainDependencies(), changes));
            List dependencies = ContainerUtil.concat(dataWithDependencies.getTestDependencies(), dataWithDependencies.getMainDependencies());
            result.add(new MavenModuleImportData(project2, mainAndTestModules.getTestData(), dependencies, changes));
            ArrayList<MavenModuleImportData> arrayList = result;
            if (arrayList == null) {
                MavenProjectImportContextProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List<MavenModuleImportData> list = List.of(new MavenModuleImportData(project2, moduleData, ContainerUtil.concat(dataWithDependencies.getMainDependencies(), dataWithDependencies.getTestDependencies()), changes));
        if (list == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected MavenProjectImportData getModuleImportData(MavenProject project2, String moduleName, Map<String, Module> legacyModuleByName, MavenProjectChanges changes) {
        MavenJavaVersionHolder javaVersions = MavenModelUtil.getMavenJavaVersions(project2);
        MavenModuleType type2 = MavenProjectImportContextProvider.getModuleType(project2, javaVersions);
        ModuleData moduleData = this.getModuleData(project2, moduleName, type2, javaVersions, legacyModuleByName);
        if (type2 != MavenModuleType.AGGREGATOR_MAIN_TEST) {
            return new MavenProjectImportData(project2, moduleData, changes, null);
        }
        String moduleMainName = moduleName + ".main";
        ModuleData mainData = this.getModuleData(project2, moduleMainName, MavenModuleType.MAIN, javaVersions, legacyModuleByName);
        String moduleTestName = moduleName + ".test";
        ModuleData testData = this.getModuleData(project2, moduleTestName, MavenModuleType.TEST, javaVersions, legacyModuleByName);
        SplittedMainAndTestModules mainAndTestModules = new SplittedMainAndTestModules(mainData, testData);
        return new MavenProjectImportData(project2, moduleData, changes, mainAndTestModules);
    }

    private static MavenModuleType getModuleType(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        if (MavenProjectImportContextProvider.needSplitMainAndTest(project2, mavenJavaVersions)) {
            return MavenModuleType.AGGREGATOR_MAIN_TEST;
        }
        if (project2.isAggregator()) {
            return MavenModuleType.AGGREGATOR;
        }
        return MavenModuleType.MAIN_TEST;
    }

    private static boolean needSplitMainAndTest(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        return !project2.isAggregator() && mavenJavaVersions.needSeparateTestModule() && MavenModelUtil.isCompilerTestSupport(project2);
    }

    protected ModuleData getModuleData(MavenProject project2, String moduleName, MavenModuleType type2, MavenJavaVersionHolder javaVersionHolder, Map<String, Module> legacyModuleByName) {
        return new ModuleData(moduleName, type2, javaVersionHolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleImportDataDependecyContext {
        @NotNull
        final List<MavenModuleImportData> allModuleDataWithDependencies;
        @NotNull
        final List<MavenModuleImportData> changedModuleDataWithDependencies;
        @NotNull
        final List<Module> legacyCreatedModules;

        private ModuleImportDataDependecyContext(@NotNull List<MavenModuleImportData> allModuleDataWithDependencies, @NotNull List<MavenModuleImportData> changedModuleDataWithDependencies, @NotNull List<Module> legacyCreatedModules) {
            if (allModuleDataWithDependencies == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(0);
            }
            if (changedModuleDataWithDependencies == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(1);
            }
            if (legacyCreatedModules == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(2);
            }
            this.allModuleDataWithDependencies = allModuleDataWithDependencies;
            this.changedModuleDataWithDependencies = changedModuleDataWithDependencies;
            this.legacyCreatedModules = legacyCreatedModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allModuleDataWithDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changedModuleDataWithDependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "legacyCreatedModules";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataDependecyContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleImportDataContext {
        @NotNull
        final List<MavenProjectImportData> importData;
        @NotNull
        final Map<MavenProject, String> moduleNameByProject;
        @NotNull
        final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
        @NotNull
        final List<Module> legacyObsoleteModules;
        final boolean hasChanges;

        private ModuleImportDataContext(@NotNull List<MavenProjectImportData> importData, @NotNull Map<MavenProject, String> moduleNameByProject, @NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, @NotNull List<Module> legacyObsoleteModules, boolean hasChanges) {
            if (importData == null) {
                ModuleImportDataContext.$$$reportNull$$$0(0);
            }
            if (moduleNameByProject == null) {
                ModuleImportDataContext.$$$reportNull$$$0(1);
            }
            if (moduleImportDataByMavenId == null) {
                ModuleImportDataContext.$$$reportNull$$$0(2);
            }
            if (legacyObsoleteModules == null) {
                ModuleImportDataContext.$$$reportNull$$$0(3);
            }
            this.importData = importData;
            this.moduleNameByProject = moduleNameByProject;
            this.moduleImportDataByMavenId = moduleImportDataByMavenId;
            this.legacyObsoleteModules = legacyObsoleteModules;
            this.hasChanges = hasChanges;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleNameByProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleImportDataByMavenId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "legacyObsoleteModules";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

