/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.PasswordAuthenticationData;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.CertificateCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;

public class UsernamePasswordCallback
extends AuthCallbackCase {
    @NonNls
    private static final String COULD_NOT_AUTHENTICATE_TO_SERVER_MESSAGE = "could not authenticate to server";
    @NonNls
    private static final String UNABLE_TO_CONNECT_MESSAGE = "Unable to connect to a repository";
    @NonNls
    private static final String AUTHENTICATION_FAILED_MESSAGE = "Authentication failed";
    @NonNls
    private static final String INVALID_CREDENTIALS_FOR_SVN_PROTOCOL = "svn: E170001: Can't get";
    @NonNls
    private static final String PASSWORD_STRING = "password";
    private static final Pattern UNABLE_TO_CONNECT_TO_URL_PATTERN = Pattern.compile("Unable to connect to a repository at URL '(.*)'");
    protected AuthenticationData myAuthentication;

    UsernamePasswordCallback(@NotNull AuthenticationService authenticationService, Url url) {
        if (authenticationService == null) {
            UsernamePasswordCallback.$$$reportNull$$$0(0);
        }
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(AUTHENTICATION_FAILED_MESSAGE) || error.contains(INVALID_CREDENTIALS_FOR_SVN_PROTOCOL) && error.contains(PASSWORD_STRING) || error.contains(UNABLE_TO_CONNECT_MESSAGE) && !CertificateCallbackCase.isCertificateVerificationFailed(error) || StringUtil.containsIgnoreCase((String)error, (String)COULD_NOT_AUTHENTICATE_TO_SERVER_MESSAGE);
    }

    @Override
    boolean getCredentials(String errText) {
        this.myAuthentication = this.myAuthenticationService.requestCredentials(this.myUrl != null ? this.myUrl : this.parseUrlFromError(errText), this.getType());
        return this.myAuthentication != null;
    }

    public String getType() {
        return "svn.simple";
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            UsernamePasswordCallback.$$$reportNull$$$0(1);
        }
        if (this.myAuthentication instanceof PasswordAuthenticationData) {
            PasswordAuthenticationData auth = (PasswordAuthenticationData)this.myAuthentication;
            command.put("--username");
            command.put(auth.getUserName());
            command.put("--password");
            command.put(auth.getPassword());
            if (!auth.isStorageAllowed()) {
                command.put("--no-auth-cache");
            }
        }
    }

    private Url parseUrlFromError(String errorText) {
        Matcher matcher = UNABLE_TO_CONNECT_TO_URL_PATTERN.matcher(errorText);
        String urlValue = null;
        if (matcher.find()) {
            urlValue = matcher.group(1);
        }
        return urlValue != null ? this.parseUrl(urlValue) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/UsernamePasswordCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

