/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.resolver;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import de.plushnikov.intellij.plugin.LombokClassNames;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokExternalLibraryResolver
extends ExternalLibraryResolver {
    private final Set<String> allLombokPackages = LombokClassNames.MAIN_LOMBOK_CLASSES.stream().map(StringUtil::getPackageName).collect(Collectors.toUnmodifiableSet());
    private final Map<String, String> simpleNameToFQNameMap = LombokClassNames.MAIN_LOMBOK_CLASSES.stream().collect(Collectors.toMap(StringUtil::getShortName, Function.identity()));
    private static final ExternalLibraryDescriptor LOMBOK = new ExternalLibraryDescriptor("org.projectlombok", "lombok", null, null, "1.18.22");

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            LombokExternalLibraryResolver.$$$reportNull$$$0(0);
        }
        if (isAnnotation == null) {
            LombokExternalLibraryResolver.$$$reportNull$$$0(1);
        }
        if (contextModule == null) {
            LombokExternalLibraryResolver.$$$reportNull$$$0(2);
        }
        if (isAnnotation == ThreeState.YES && this.simpleNameToFQNameMap.containsKey(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult(this.simpleNameToFQNameMap.get(shortClassName), LOMBOK);
        }
        return null;
    }

    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            LombokExternalLibraryResolver.$$$reportNull$$$0(3);
        }
        if (this.allLombokPackages.contains(packageName)) {
            return LOMBOK;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/resolver/LombokExternalLibraryResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

