/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/qodana/ui/ImageLoader;", "", "()V", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.qodana"})
final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE;

    @Nullable
    public final Image loadImage(@NotNull String path, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            Image image2 = img;
            BufferedImage bufferedImage = img;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"img");
            image = (Image)new JBHiDPIScaledImage(image2, width, height, bufferedImage.getType());
        }
        catch (Exception e) {
            ImageLoader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ImageLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Image " + path + " is not loaded, " + e);
            image = null;
        }
        return image;
    }

    private ImageLoader() {
    }

    static {
        ImageLoader imageLoader;
        INSTANCE = imageLoader = new ImageLoader();
    }
}

