/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/ui/SvgLoader;", "", "()V", "loadSvg", "Lcom/intellij/util/ui/JBImageIcon;", "path", "", "comp", "Ljavax/swing/JComponent;", "intellij.qodana"})
final class SvgLoader {
    @NotNull
    public static final SvgLoader INSTANCE;

    @Nullable
    public final JBImageIcon loadSvg(@NotNull String path, @NotNull JComponent comp) {
        JBImageIcon jBImageIcon;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(path);
            Intrinsics.checkNotNull((Object)inputStream);
            byte[] bytes = inputStream.readAllBytes();
            ScaleContext scaleContext = ScaleContext.create((Component)comp);
            Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"ScaleContext.create(comp)");
            ScaleContext ctx = scaleContext;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            BufferedImage image = SVGLoader.loadWithoutCache((byte[])bytes, (float)((float)ctx.getScale(ScaleType.SYS_SCALE)));
            Image hiDpi = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ctx);
            jBImageIcon = new JBImageIcon(hiDpi);
        }
        catch (Exception e) {
            SvgLoader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SvgLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Svg " + path + " is not loaded, " + e);
            jBImageIcon = null;
        }
        return jBImageIcon;
    }

    private SvgLoader() {
    }

    static {
        SvgLoader svgLoader;
        INSTANCE = svgLoader = new SvgLoader();
    }
}

