/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

public abstract class RepeatCount {
    public static final String ONCE = "Once";
    public static final String N = "N Times";
    public static final String UNTIL_FAILURE = "Until Failure";
    public static final String UNLIMITED = "Until Stopped";
    public static final String[] REPEAT_TYPES = new String[]{"Once", "N Times", "Until Failure", "Until Stopped"};

    public static String getCountString(int count) {
        if (count > 1) {
            return "@N Times" + count;
        }
        if (count == -1) {
            return UNLIMITED;
        }
        if (count == -2) {
            return UNTIL_FAILURE;
        }
        return ONCE;
    }

    public static int getCount(String countString) {
        if (countString.equals(ONCE)) {
            return 1;
        }
        if (countString.equals(UNLIMITED)) {
            return -1;
        }
        if (countString.equals(UNTIL_FAILURE)) {
            return -2;
        }
        String prefix = "@N Times";
        if (countString.startsWith("@N Times")) {
            try {
                return Integer.parseInt(countString.substring("@N Times".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

