/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/IDEAProjectFilesPostProcessor;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "onSuccessImport", "", "project", "Lcom/intellij/openapi/project/Project;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "ProjectLayout", "intellij.gradle.common"})
public final class IDEAProjectFilesPostProcessor
implements ConfigurationHandler {
    /*
     * WARNING - void declaration
     */
    public void onSuccessImport(@NotNull Project project, @Nullable ProjectData projectData, @NotNull IdeModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map $this$filterValues$iv;
        String string2;
        Object object;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        Path f;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (projectData == null) {
            return;
        }
        ExternalProjectsManagerImpl externalProjectsManagerImpl = ExternalProjectsManagerImpl.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)externalProjectsManagerImpl, (String)"ExternalProjectsManagerImpl.getInstance(project)");
        ExternalSystemTaskActivator activator = externalProjectsManagerImpl.getTaskActivator();
        ExternalSystemTaskActivator.TaskActivationEntry taskActivationEntry = new ExternalSystemTaskActivator.TaskActivationEntry(GradleConstants.SYSTEM_ID, ExternalSystemTaskActivator.Phase.AFTER_SYNC, projectData.getLinkedExternalProjectPath(), "processIdeaSettings");
        activator.removeTask(taskActivationEntry);
        Object object2 = configuration.find("requiresPostprocessing");
        if (!(object2 instanceof Boolean)) {
            object2 = null;
        }
        if (Intrinsics.areEqual((Object)((Boolean)object2), (Object)true) ^ true) {
            return;
        }
        activator.addTask(taskActivationEntry);
        Path path = f = new File(projectData.getLinkedExternalProjectPath()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"f");
        Path extProjectDir = PathKt.isDirectory((Path)path) ? f : f.getParent();
        Path path2 = ProjectKt.getStateStore((Project)project).getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"project.stateStore.projectFilePath");
        Path path3 = path2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"project.stateStore.projectFilePath.parent");
        String dotIdeaDirPath = PathKt.getSystemIndependentPath((Path)path3);
        DataNode dataNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)projectData.getOwner(), (String)projectData.getLinkedExternalProjectPath());
        if (dataNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"ExternalSystemApiUtil.fi\u2026nalProjectPath) ?: return");
        DataNode projectNode = dataNode;
        Collection collection = ExternalSystemApiUtil.getChildren((DataNode)projectNode, (Key)ProjectKeys.MODULE);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026Node, ProjectKeys.MODULE)");
        Collection moduleNodes = collection;
        Iterable $this$flatMap$iv = moduleNodes;
        boolean $i$f$flatMap232 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DataNode it = (DataNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ExternalSystemApiUtil.getChildren((DataNode)it, GradleSourceSetData.KEY);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sourceSetNodes = (List)destination$iv$iv;
        Iterable $i$f$flatMap232 = CollectionsKt.plus((Collection)moduleNodes, (Iterable)sourceSetNodes);
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean bl = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            DataNode dataNode2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"it");
            Object object4 = dataNode2.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it.data");
            key$iv$iv = ((ModuleData)object4).getId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            it = (DataNode)element$iv$iv;
            object = list$iv$iv;
            boolean bl3 = false;
            DataNode dataNode3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode3, (String)"it");
            Module module = modelsProvider.findIdeModule((ModuleData)dataNode3.getData());
            string2 = module != null ? module.getModuleFilePath() : null;
            object.add(string2);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl3 = false;
            Collection collection2 = it;
            if (!(!collection2.isEmpty())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl4 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map object5 = destination$iv$iv3;
            boolean bl5 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            string2 = it$iv$iv.getKey();
            object = object5;
            boolean bl42 = false;
            String string3 = (String)CollectionsKt.first((List)((List)it.getValue()));
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            object.put(string2, string4);
        }
        Map sourceSetsToImls = destination$iv$iv3;
        ProjectLayout layout = new ProjectLayout(dotIdeaDirPath, sourceSetsToImls);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Files.writeString(extProjectDir.resolve("layout.json"), (CharSequence)gson.toJson((Object)layout), new OpenOption[0]);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/IDEAProjectFilesPostProcessor$ProjectLayout;", "", "ideaDirPath", "", "modulesMap", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getIdeaDirPath", "()Ljava/lang/String;", "getModulesMap", "()Ljava/util/Map;", "intellij.gradle.common"})
    public static final class ProjectLayout {
        @NotNull
        private final String ideaDirPath;
        @NotNull
        private final Map<String, String> modulesMap;

        @NotNull
        public final String getIdeaDirPath() {
            return this.ideaDirPath;
        }

        @NotNull
        public final Map<String, String> getModulesMap() {
            return this.modulesMap;
        }

        public ProjectLayout(@NotNull String ideaDirPath, @NotNull Map<String, String> modulesMap) {
            Intrinsics.checkNotNullParameter((Object)ideaDirPath, (String)"ideaDirPath");
            Intrinsics.checkNotNullParameter(modulesMap, (String)"modulesMap");
            this.ideaDirPath = ideaDirPath;
            this.modulesMap = modulesMap;
        }
    }
}

