/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u001c2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/AnalyzerExtensions$AnalyzerExtension;", "reasonableInlineRules", "", "Lorg/jetbrains/kotlin/resolve/inline/ReasonableInlineRule;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "checkDefaultValue", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "ktParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkDefaults", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "checkHasInlinableAndNullability", "checkInlinableParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkModalityAndOverrides", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "functionOrProperty", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "notSupportedInInlineCheck", "process", "descriptor", "frontend"})
public final class InlineAnalyzerExtension
implements AnalyzerExtensions.AnalyzerExtension {
    @NotNull
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public InlineAnalyzerExtension(@NotNull Iterable<? extends ReasonableInlineRule> reasonableInlineRules, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(reasonableInlineRules, (String)"reasonableInlineRules");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.reasonableInlineRules = reasonableInlineRules;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public void process(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtCallableDeclaration functionOrProperty, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)functionOrProperty, (String)"functionOrProperty");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.checkModalityAndOverrides(descriptor2, functionOrProperty, trace);
        this.notSupportedInInlineCheck(functionOrProperty, trace);
        if (descriptor2 instanceof FunctionDescriptor) {
            boolean bl = functionOrProperty instanceof KtNamedFunction;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$42 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$42 = "Function descriptor " + descriptor2 + " should have corresponded KtNamedFunction, but has " + functionOrProperty;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$42);
            }
            this.checkDefaults((FunctionDescriptor)descriptor2, (KtFunction)((KtNamedFunction)functionOrProperty), trace);
            this.checkHasInlinableAndNullability((FunctionDescriptor)descriptor2, (KtFunction)functionOrProperty, trace);
        } else {
            boolean bl = descriptor2 instanceof PropertyDescriptor;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$52 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$52 = "PropertyDescriptor expected, but was " + descriptor2;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$52);
            }
            bl = functionOrProperty instanceof KtProperty;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Property descriptor " + descriptor2 + " should have corresponded KtProperty, but has " + functionOrProperty;
                throw new AssertionError((Object)string2);
            }
            boolean hasBackingField = Intrinsics.areEqual(trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)descriptor2), (Object)true);
            if (hasBackingField || ((KtProperty)functionOrProperty).getDelegateExpression() != null) {
                trace.report(Errors.INLINE_PROPERTY_WITH_BACKING_FIELD.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
        }
    }

    private final void notSupportedInInlineCheck(KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace){
            final /* synthetic */ BindingTrace $trace;
            {
                this.$trace = $trace;
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitKtElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitClass(@NotNull KtClass klass) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)klass), "Local classes"));
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)function2), "Local functions"));
                }
            }
        };
        functionOrProperty.acceptChildren((PsiElementVisitor)visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        List list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"function.valueParameters");
        List ktParameters = list2;
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            KtParameter ktParameter = (KtParameter)ktParameters.get(parameter.getIndex());
            boolean inheritsDefaultValue = !parameter.declaresDefaultValue() && DescriptorUtilsKt.declaresOrInheritsDefaultValue(parameter);
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"ktParameter");
            if (this.checkInlinableParameter(parameterDescriptor, (KtElement)ktParameter, functionDescriptor, null) || inheritsDefaultValue) {
                if (inheritsDefaultValue || !this.languageVersionSettings.supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters)) {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Functional parameters with inherited default values"));
                } else {
                    this.checkDefaultValue(trace, parameter, ktParameter);
                }
            }
            if (!functionDescriptor.isSuspend() || !InlineUtil.isInlineParameterExceptNullability(parameter) || !CoroutineUtilKt.getHasSuspendFunctionType(parameter)) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Suspend functional parameters with default values"));
        }
    }

    private final void checkDefaultValue(BindingTrace trace, ValueParameterDescriptor parameterDescriptor, KtParameter ktParameter) {
        block1: {
            KtExpression ktExpression = ktParameter.getDefaultValue();
            if (ktExpression == null) break block1;
            KtExpression defaultValue = ktExpression;
            boolean bl = false;
            if (!InlineUtil.isInlinableParameterExpression(KtPsiUtil.deparenthesize((KtExpression)defaultValue))) {
                trace.report(Errors.INVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE.on((KtElement)((PsiElement)defaultValue), defaultValue, parameterDescriptor));
            }
        }
    }

    private final void checkModalityAndOverrides(CallableMemberDescriptor callableDescriptor, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        boolean overridesAnything;
        if (callableDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (DescriptorVisibilities.isPrivate(callableDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> collection = callableDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"callableDescriptor.overriddenDescriptors");
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List list2 = functionOrProperty.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"functionOrProperty.typeParameters");
            List ktTypeParameters = list2;
            for (TypeParameterDescriptor typeParameter : callableDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = (KtTypeParameter)ktTypeParameters.get(typeParameter.getIndex());
                KtModifierList ktModifierList = ktTypeParameter.getModifierList();
                if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    ktModifierList = (PsiElement)ktTypeParameter;
                }
                KtModifierList reportOn = ktModifierList;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on((PsiElement)reportOn));
            }
        }
        if (KtDescriptorUtilKt.isEffectivelyFinal(callableDescriptor, true)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)functionOrProperty)));
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        boolean bl;
        block8: {
            boolean hasInlineArgs = false;
            List list2 = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"function.valueParameters");
            Iterable iterable = list2;
            List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"functionDescriptor.valueParameters");
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list3);
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Pair pair = (Pair)t;
                boolean bl2 = false;
                KtParameter parameter = (KtParameter)pair.component1();
                ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
                ParameterDescriptor parameterDescriptor = descriptor2;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                hasInlineArgs |= this.checkInlinableParameter(parameterDescriptor, (KtElement)parameter, functionDescriptor, trace);
            }
            if (hasInlineArgs) {
                return;
            }
            if (InlineOnlyKt.isInlineWithReified(functionDescriptor) || InlineOnlyKt.isInlineOnly(functionDescriptor) || functionDescriptor.isExpect() || functionDescriptor.isSuspend()) {
                return;
            }
            Iterable<ReasonableInlineRule> $this$any$iv = this.reasonableInlineRules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object object : $this$any$iv) {
                    ReasonableInlineRule it = (ReasonableInlineRule)object;
                    boolean bl3 = false;
                    CallableMemberDescriptor callableMemberDescriptor = functionDescriptor;
                    KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)function2;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    if (!it.isInlineReasonable(callableMemberDescriptor, ktCallableDeclaration, bindingContext)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KtModifierList ktModifierList = function2.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
            ktModifierList = (PsiElement)function2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierList, (String)"function.modifierList?.g\u2026LINE_KEYWORD) ?: function");
        KtModifierList reportOn = ktModifierList;
        trace.report(Errors.NOTHING_TO_INLINE.on((PsiElement)reportOn));
    }

    private final boolean checkInlinableParameter(ParameterDescriptor parameter, KtElement expression2, CallableDescriptor functionDescriptor, BindingTrace trace) {
        if (InlineUtil.isInlineParameterExceptNullability(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression2), expression2, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

