/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentInAnotherBuildProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public class DefaultLocalComponentRegistry
implements LocalComponentRegistry {
    private final BuildIdentifier thisBuild;
    private final ProjectStateRegistry projectStateRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final LocalComponentProvider provider;
    private final LocalComponentInAnotherBuildProvider otherBuildProvider;
    private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentMetadata, ?>> projects = new ConcurrentHashMap();

    public DefaultLocalComponentRegistry(BuildIdentifier thisBuild, ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, LocalComponentProvider provider, LocalComponentInAnotherBuildProvider otherBuildProvider) {
        this.thisBuild = thisBuild;
        this.projectStateRegistry = projectStateRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.provider = provider;
        this.otherBuildProvider = otherBuildProvider;
    }

    @Override
    public LocalComponentMetadata getComponent(ProjectComponentIdentifier projectIdentifier) {
        CalculatedValueContainer valueContainer = this.projects.computeIfAbsent(projectIdentifier, projectComponentIdentifier -> {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
            return this.calculatedValueContainerFactory.create(Describables.of("metadata of", projectIdentifier), new MetadataSupplier(projectState));
        });
        valueContainer.finalizeIfNotAlready();
        return (LocalComponentMetadata)valueContainer.get();
    }

    private class MetadataSupplier
    implements ValueCalculator<LocalComponentMetadata> {
        private final ProjectState projectState;

        public MetadataSupplier(ProjectState projectState) {
            this.projectState = projectState;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public boolean usesMutableProjectState() {
            return false;
        }

        @Override
        public ProjectInternal getOwningProject() {
            return null;
        }

        @Override
        public LocalComponentMetadata calculateValue(NodeExecutionContext context) {
            if (this.isLocalProject(this.projectState.getComponentIdentifier())) {
                return DefaultLocalComponentRegistry.this.provider.getComponent(this.projectState);
            }
            return DefaultLocalComponentRegistry.this.otherBuildProvider.getComponent(this.projectState);
        }

        private boolean isLocalProject(ProjectComponentIdentifier projectIdentifier) {
            return projectIdentifier.getBuild().equals(DefaultLocalComponentRegistry.this.thisBuild);
        }
    }
}

