/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

class DefaultPendingDependenciesVisitor
implements PendingDependenciesVisitor {
    private final ResolveState resolveState;
    private List<PendingDependencies> noLongerPending;

    DefaultPendingDependenciesVisitor(ResolveState resolveState) {
        this.resolveState = resolveState;
    }

    @Override
    public PendingDependenciesVisitor.PendingState maybeAddAsPendingDependency(NodeState node, DependencyState dependencyState) {
        ModuleIdentifier key = dependencyState.getModuleIdentifier();
        boolean isConstraint = dependencyState.getDependency().isConstraint();
        if (!isConstraint) {
            if (this.markNotPending(key)) {
                return PendingDependenciesVisitor.PendingState.NOT_PENDING_ACTIVATING;
            }
            return PendingDependenciesVisitor.PendingState.NOT_PENDING;
        }
        ModuleResolveState module = this.resolveState.getModule(key);
        boolean pending = module.isPending();
        if (!pending) {
            return PendingDependenciesVisitor.PendingState.NOT_PENDING;
        }
        module.registerConstraintProvider(node);
        return PendingDependenciesVisitor.PendingState.PENDING;
    }

    @Override
    public boolean markNotPending(ModuleIdentifier id) {
        return this.markNoLongerPending(this.resolveState.getModule(id).getPendingDependencies());
    }

    private boolean markNoLongerPending(PendingDependencies pendingDependencies) {
        boolean activatedPending = false;
        if (pendingDependencies.hasConstraintProviders()) {
            if (this.noLongerPending == null) {
                this.noLongerPending = Lists.newArrayList();
            }
            this.noLongerPending.add(pendingDependencies);
            activatedPending = pendingDependencies.shouldReportActivatePending();
        }
        pendingDependencies.increaseHardEdgeCount();
        return activatedPending;
    }

    @Override
    public void complete() {
        if (this.noLongerPending != null) {
            for (PendingDependencies pendingDependencies : this.noLongerPending) {
                pendingDependencies.turnIntoHardDependencies();
            }
            this.noLongerPending = null;
        }
    }
}

