/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class VirtualPlatformState {
    private final Comparator<String> vC;
    private final ModuleResolveState platformModule;
    private final ResolveOptimizations resolveOptimizations;
    private final Set<ModuleResolveState> participatingModules = Sets.newLinkedHashSet();
    private final List<EdgeState> orphanEdges = Lists.newArrayListWithExpectedSize((int)2);
    private boolean hasForcedParticipatingModule;

    public VirtualPlatformState(Comparator<Version> versionComparator, VersionParser versionParser, ModuleResolveState platformModule, ResolveOptimizations resolveOptimizations) {
        this.vC = (o1, o2) -> versionComparator.compare(versionParser.transform((String)o2), versionParser.transform((String)o1));
        this.platformModule = platformModule;
        this.resolveOptimizations = resolveOptimizations;
    }

    void participatingModule(ModuleResolveState state2) {
        state2.registerPlatformOwner(this);
        if (this.participatingModules.add(state2)) {
            this.resolveOptimizations.declareVirtualPlatformInUse();
            ComponentState selected = this.platformModule.getSelected();
            if (selected != null) {
                for (NodeState nodeState : selected.getNodes()) {
                    nodeState.markForVirtualPlatformRefresh();
                }
            }
            this.hasForcedParticipatingModule |= this.isParticipatingModuleForced(state2);
        }
    }

    @Nullable
    private String getForcedVersion() {
        String version = null;
        for (SelectorState selector : this.platformModule.getSelectors()) {
            ComponentSelector requested;
            if (!selector.hasStrongOpinion() || !((requested = selector.getRequested()) instanceof ModuleComponentSelector)) continue;
            String nv = ((ModuleComponentSelector)requested).getVersion();
            if (version != null && this.vC.compare(nv, version) >= 0) continue;
            version = nv;
        }
        return version;
    }

    List<String> getCandidateVersions() {
        String forcedVersion = this.getForcedVersion();
        ComponentState selectedPlatformComponent = this.platformModule.getSelected();
        ArrayList sorted = Lists.newArrayListWithCapacity((int)(this.participatingModules.size() + 1));
        sorted.add(selectedPlatformComponent.getVersion());
        for (ModuleResolveState module : this.participatingModules) {
            ComponentState selected = module.getSelected();
            if (selected == null) continue;
            sorted.add(selected.getVersion());
        }
        sorted.sort(this.vC);
        if (forcedVersion != null) {
            return sorted.subList(sorted.indexOf(forcedVersion), sorted.size());
        }
        return sorted;
    }

    Set<ModuleResolveState> getParticipatingModules() {
        return this.participatingModules;
    }

    @Nullable
    public ComponentIdentifier getSelectedPlatformId() {
        ComponentState selected = this.platformModule.getSelected();
        if (selected != null) {
            return selected.getComponentId();
        }
        return null;
    }

    boolean isForced() {
        return this.hasForcedParticipatingModule || this.isSelectedPlatformForced();
    }

    private boolean isSelectedPlatformForced() {
        boolean forced = this.platformModule.getSelected().hasStrongOpinion();
        if (forced) {
            this.resolveOptimizations.declareForcedPlatformInUse();
        }
        return forced;
    }

    private boolean isParticipatingModuleForced(ModuleResolveState participatingModule) {
        boolean forced;
        ComponentState selected = participatingModule.getSelected();
        boolean bl = forced = selected != null && selected.hasStrongOpinion();
        if (forced) {
            this.resolveOptimizations.declareForcedPlatformInUse();
        }
        return forced;
    }

    void addOrphanEdge(EdgeState edge) {
        this.orphanEdges.add(edge);
    }

    void attachOrphanEdges() {
        for (EdgeState orphanEdge : this.orphanEdges) {
            orphanEdge.attachToTargetConfigurations();
        }
        this.orphanEdges.clear();
    }

    public boolean isGreaterThanForcedVersion(String version) {
        String forcedVersion = this.getForcedVersion();
        if (forcedVersion == null) {
            return false;
        }
        return this.vC.compare(forcedVersion, version) > 0;
    }
}

