/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.util.Path;

public class RootScriptDomainObjectContext
implements DomainObjectContext,
ModelContainer<Object> {
    private static final Object MODEL = new Object();
    public static final DomainObjectContext INSTANCE = new RootScriptDomainObjectContext();
    public static final DomainObjectContext PLUGINS = new RootScriptDomainObjectContext(){

        @Override
        public boolean isPluginContext() {
            return true;
        }
    };

    private RootScriptDomainObjectContext() {
    }

    @Override
    public Path identityPath(String name) {
        return Path.path(name);
    }

    @Override
    public Path projectPath(String name) {
        return Path.path(name);
    }

    @Override
    public Path getProjectPath() {
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getProject() {
        return null;
    }

    public ModelContainer<Object> getModel() {
        return this;
    }

    @Override
    public boolean hasMutableState() {
        return true;
    }

    @Override
    public <S> S fromMutableState(Function<? super Object, ? extends S> factory) {
        return factory.apply(MODEL);
    }

    @Override
    public <S> S forceAccessToMutableState(Function<? super Object, ? extends S> factory) {
        return factory.apply(MODEL);
    }

    @Override
    public void applyToMutableState(Consumer<? super Object> action) {
        action.accept(MODEL);
    }

    @Override
    public Path getBuildPath() {
        return Path.ROOT;
    }

    @Override
    public boolean isScript() {
        return true;
    }

    @Override
    public boolean isRootScript() {
        return true;
    }

    @Override
    public boolean isPluginContext() {
        return false;
    }

    @Override
    public <T> CalculatedModelValue<T> newCalculatedValue(@Nullable T initialValue) {
        return new CalculatedModelValueImpl<T>(initialValue);
    }

    private static class CalculatedModelValueImpl<T>
    implements CalculatedModelValue<T> {
        private volatile T value;

        CalculatedModelValueImpl(@Nullable T initialValue) {
            this.value = initialValue;
        }

        @Override
        public T get() throws IllegalStateException {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                throw new IllegalStateException("No value is available.");
            }
            return currentValue;
        }

        @Override
        public T getOrNull() {
            return this.value;
        }

        @Override
        public void set(T newValue) {
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T update(Function<T, T> updateFunction) {
            CalculatedModelValueImpl calculatedModelValueImpl = this;
            synchronized (calculatedModelValueImpl) {
                T newValue = updateFunction.apply(this.value);
                this.value = newValue;
                return newValue;
            }
        }
    }
}

