/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public interface ValueSupplier {
    public ValueProducer getProducer();

    public boolean calculatePresence(ValueConsumer var1);

    public static class ChangingExecutionTimeValue<T>
    extends ExecutionTimeValue<T> {
        private final ProviderInternal<T> provider;

        private ChangingExecutionTimeValue(ProviderInternal<T> provider) {
            this.provider = provider;
        }

        @Override
        public boolean isChangingValue() {
            return true;
        }

        @Override
        public boolean hasChangingContent() {
            return true;
        }

        @Override
        public ProviderInternal<T> getChangingValue() {
            return this.provider;
        }

        @Override
        public ProviderInternal<T> toProvider() {
            return this.provider;
        }

        @Override
        public ExecutionTimeValue<T> withChangingContent() {
            return this;
        }
    }

    public static class FixedExecutionTimeValue<T>
    extends ExecutionTimeValue<T> {
        private final T value;
        private final boolean changingContent;

        private FixedExecutionTimeValue(T value, boolean changingContent) {
            this.value = value;
            this.changingContent = changingContent;
        }

        @Override
        public boolean isFixedValue() {
            return true;
        }

        @Override
        public boolean hasChangingContent() {
            return this.changingContent;
        }

        @Override
        public T getFixedValue() {
            return this.value;
        }

        @Override
        public Value<T> toValue() {
            return Value.of(this.value);
        }

        @Override
        public ProviderInternal<T> toProvider() {
            if (this.changingContent) {
                return new Providers.FixedValueWithChangingContentProvider<T>(this.value);
            }
            return Providers.of(this.value);
        }

        @Override
        public ExecutionTimeValue<T> withChangingContent() {
            return new FixedExecutionTimeValue<T>(this.value, true);
        }
    }

    public static class MissingExecutionTimeValue
    extends ExecutionTimeValue<Object> {
        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public ProviderInternal<Object> toProvider() {
            return Providers.notDefined();
        }

        @Override
        public ExecutionTimeValue<Object> withChangingContent() {
            return this;
        }

        @Override
        public Value<Object> toValue() {
            return Value.missing();
        }
    }

    public static abstract class ExecutionTimeValue<T> {
        private static final MissingExecutionTimeValue MISSING = new MissingExecutionTimeValue();

        public boolean isMissing() {
            return false;
        }

        public boolean isFixedValue() {
            return false;
        }

        public boolean isChangingValue() {
            return false;
        }

        public boolean hasChangingContent() {
            return false;
        }

        public T getFixedValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public ProviderInternal<T> getChangingValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Value<T> toValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public abstract ProviderInternal<T> toProvider();

        public abstract ExecutionTimeValue<T> withChangingContent();

        public static <T> ExecutionTimeValue<T> missing() {
            return (ExecutionTimeValue)Cast.uncheckedCast(MISSING);
        }

        public static <T> ExecutionTimeValue<T> fixedValue(T value) {
            assert (value != null);
            return new FixedExecutionTimeValue(value, false);
        }

        public static <T> ExecutionTimeValue<T> ofNullable(@Nullable T value) {
            if (value == null) {
                return ExecutionTimeValue.missing();
            }
            return ExecutionTimeValue.fixedValue(value);
        }

        public static <T> ExecutionTimeValue<T> value(Value<T> value) {
            if (value.isMissing()) {
                return ExecutionTimeValue.missing();
            }
            return ExecutionTimeValue.fixedValue(value.get());
        }

        public static <T> ExecutionTimeValue<T> changingValue(ProviderInternal<T> provider) {
            return new ChangingExecutionTimeValue(provider);
        }
    }

    public static class Missing<T>
    implements Value<T> {
        private final List<DisplayName> path;

        private Missing() {
            this.path = ImmutableList.of();
        }

        private Missing(List<DisplayName> path) {
            this.path = path;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public T get() throws IllegalStateException {
            throw new IllegalStateException();
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        public <S> S orElse(S defaultValue) {
            return defaultValue;
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            return this.path;
        }

        @Override
        public <S> Value<S> asType() {
            return (Value)Cast.uncheckedCast(this);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            if (displayName == null) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + 1));
            builder.add((Object)displayName);
            builder.addAll(this.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            if (this.path.isEmpty()) {
                return rightValue.asType();
            }
            Missing other = (Missing)rightValue;
            if (other.path.isEmpty()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + other.path.size()));
            builder.addAll(this.path);
            builder.addAll(other.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }
    }

    public static class Present<T>
    implements Value<T> {
        private final T result;

        private Present(T result2) {
            this.result = result2;
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        @Override
        public T get() throws IllegalStateException {
            return this.result;
        }

        @Override
        public T orNull() {
            return this.result;
        }

        @Override
        public <S> S orElse(S defaultValue) {
            return (S)Cast.uncheckedCast(this.result);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            return this;
        }

        @Override
        public <S> Value<S> asType() {
            throw new IllegalStateException();
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            throw new IllegalStateException();
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            throw new IllegalStateException();
        }
    }

    public static interface Value<T> {
        public static final Value<Object> MISSING = new Missing<Object>();
        public static final Value<Void> SUCCESS = new Present<Void>(null);

        public static <T> Value<T> ofNullable(@Nullable T value) {
            if (value == null) {
                return MISSING.asType();
            }
            return new Present(value);
        }

        public static <T> Value<T> missing() {
            return MISSING.asType();
        }

        public static <T> Value<T> of(T value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            return new Present(value);
        }

        public static Value<Void> present() {
            return SUCCESS;
        }

        public T get() throws IllegalStateException;

        @Nullable
        public T orNull();

        public <S> S orElse(S var1);

        public List<DisplayName> getPathToOrigin();

        public boolean isMissing();

        public <S> Value<S> asType();

        public Value<T> pushWhenMissing(@Nullable DisplayName var1);

        public Value<T> addPathsFrom(Value<?> var1);
    }

    public static class NoProducer
    implements ValueProducer {
        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static class UnknownProducer
    implements ValueProducer {
        @Override
        public boolean isKnown() {
            return false;
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static class PlusProducer
    implements ValueProducer {
        private final ValueProducer left;
        private final ValueProducer right;

        public PlusProducer(ValueProducer left, ValueProducer right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isKnown() {
            return this.left.isKnown() || this.right.isKnown();
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return this.left.isProducesDifferentValueOverTime() || this.right.isProducesDifferentValueOverTime();
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.left.visitProducerTasks(visitor);
            this.right.visitProducerTasks(visitor);
        }
    }

    public static class TaskProducer
    implements ValueProducer {
        private final Task task;
        private boolean content;

        public TaskProducer(Task task, boolean content) {
            this.task = task;
            this.content = content;
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            visitor.execute(this.task);
        }

        @Override
        public void visitContentProducerTasks(Action<? super Task> visitor) {
            if (this.content) {
                visitor.execute(this.task);
            }
        }
    }

    public static class ExternalValueProducer
    implements ValueProducer {
        @Override
        public boolean isProducesDifferentValueOverTime() {
            return true;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static interface ValueProducer {
        public static final NoProducer NO_PRODUCER = new NoProducer();
        public static final UnknownProducer UNKNOWN_PRODUCER = new UnknownProducer();

        default public boolean isKnown() {
            return true;
        }

        public boolean isProducesDifferentValueOverTime();

        public void visitProducerTasks(Action<? super Task> var1);

        default public void visitContentProducerTasks(Action<? super Task> visitor) {
            this.visitProducerTasks(visitor);
        }

        default public ValueProducer plus(ValueProducer producer) {
            if (this == NO_PRODUCER) {
                return producer;
            }
            if (producer == NO_PRODUCER) {
                return this;
            }
            if (producer == this) {
                return this;
            }
            return new PlusProducer(this, producer);
        }

        public static ValueProducer noProducer() {
            return NO_PRODUCER;
        }

        public static ValueProducer unknown() {
            return UNKNOWN_PRODUCER;
        }

        public static ValueProducer externalValue() {
            return new ExternalValueProducer();
        }

        public static ValueProducer task(Task task) {
            return new TaskProducer(task, true);
        }

        public static ValueProducer taskState(Task task) {
            return new TaskProducer(task, false);
        }
    }

    public static enum ValueConsumer {
        DisallowUnsafeRead,
        IgnoreUnsafeRead;

    }
}

