/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.Writer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStoreBackedResultsProvider;
import org.gradle.api.tasks.testing.TestOutputEvent;

public class InMemoryTestResultsProvider
extends TestOutputStoreBackedResultsProvider {
    private final Iterable<TestClassResult> results;

    public InMemoryTestResultsProvider(Iterable<TestClassResult> results, TestOutputStore outputStore) {
        super(outputStore);
        this.results = results;
    }

    @Override
    public boolean hasOutput(final long classId, final TestOutputEvent.Destination destination) {
        final boolean[] hasOutput = new boolean[1];
        this.withReader(new Action<TestOutputStore.Reader>(){

            @Override
            public void execute(TestOutputStore.Reader reader2) {
                hasOutput[0] = reader2.hasOutput(classId, destination);
            }
        });
        return hasOutput[0];
    }

    @Override
    public boolean hasOutput(final long classId, final long testId, final TestOutputEvent.Destination destination) {
        final boolean[] hasOutput = new boolean[1];
        this.withReader(new Action<TestOutputStore.Reader>(){

            @Override
            public void execute(TestOutputStore.Reader reader2) {
                hasOutput[0] = reader2.hasOutput(classId, testId, destination);
            }
        });
        return hasOutput[0];
    }

    @Override
    public void writeAllOutput(final long classId, final TestOutputEvent.Destination destination, final Writer writer2) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            @Override
            public void execute(TestOutputStore.Reader reader2) {
                reader2.writeAllOutput(classId, destination, writer2);
            }
        });
    }

    @Override
    public void writeNonTestOutput(final long classId, final TestOutputEvent.Destination destination, final Writer writer2) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            @Override
            public void execute(TestOutputStore.Reader reader2) {
                reader2.writeNonTestOutput(classId, destination, writer2);
            }
        });
    }

    @Override
    public void writeTestOutput(final long classId, final long testId, final TestOutputEvent.Destination destination, final Writer writer2) {
        this.withReader(new Action<TestOutputStore.Reader>(){

            @Override
            public void execute(TestOutputStore.Reader reader2) {
                reader2.writeTestOutput(classId, testId, destination, writer2);
            }
        });
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        for (TestClassResult result2 : this.results) {
            visitor.execute(result2);
        }
    }

    @Override
    public boolean isHasResults() {
        return this.results.iterator().hasNext();
    }
}

