/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import java.util.function.BiFunction;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.internal.tasks.scala.DefaultScalaPluginExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class ScalaBasePlugin
implements Plugin<Project> {
    public static final String DEFAULT_ZINC_VERSION = "1.3.5";
    private static final String DEFAULT_SCALA_ZINC_VERSION = "2.12";
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    public static final String SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME = "scalaCompilerPlugins";
    private final ObjectFactory objectFactory;
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory, JvmEcosystemUtilities jvmEcosystemUtilities) {
        this.objectFactory = objectFactory;
        this.jvmEcosystemUtilities = jvmEcosystemUtilities;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaRuntime scalaRuntime = project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, project);
        ScalaPluginExtension scalaPluginExtension = project.getExtensions().create(ScalaPluginExtension.class, "scala", DefaultScalaPluginExtension.class, new Object[0]);
        Usage incrementalAnalysisUsage = this.objectFactory.named(Usage.class, "incremental-analysis");
        this.configureConfigurations(project, incrementalAnalysisUsage, scalaPluginExtension);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime);
        this.configureSourceSetDefaults(project, incrementalAnalysisUsage, this.objectFactory, scalaRuntime);
        this.configureScaladoc(project, scalaRuntime);
    }

    private void configureConfigurations(Project project, Usage incrementalAnalysisUsage, ScalaPluginExtension scalaPluginExtension) {
        DependencyHandler dependencyHandler = project.getDependencies();
        ConfigurationInternal plugins = (ConfigurationInternal)project.getConfigurations().create(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME);
        plugins.setTransitive(false);
        plugins.setCanBeConsumed(false);
        this.jvmEcosystemUtilities.configureAsRuntimeClasspath(plugins);
        Configuration zinc = (Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME);
        zinc.setVisible(false);
        zinc.setDescription("The Zinc incremental compiler to be used for this Scala project.");
        ((DeprecatableConfiguration)zinc).deprecateForConsumption(deprecation -> deprecation.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "plugin_configuration_consumption"));
        zinc.getResolutionStrategy().eachDependency(rule -> {
            if (rule.getRequested().getGroup().equals("com.typesafe.zinc") && rule.getRequested().getName().equals(ZINC_CONFIGURATION_NAME)) {
                rule.useTarget("org.scala-sbt:zinc_2.12:1.3.5");
                rule.because("Typesafe Zinc is no longer maintained.");
            }
        });
        zinc.defaultDependencies(dependencies -> {
            dependencies.add(dependencyHandler.create("org.scala-sbt:zinc_2.12:" + (String)scalaPluginExtension.getZincVersion().get()));
            zinc.getIncoming().afterResolve(resolvableDependencies -> resolvableDependencies.getResolutionResult().allComponents(component -> {
                if (component.getModuleVersion() != null && component.getModuleVersion().getName().equals("scala-library") && !component.getModuleVersion().getVersion().startsWith(DEFAULT_SCALA_ZINC_VERSION)) {
                    throw new InvalidUserCodeException("The version of 'scala-library' was changed while using the default Zinc version. Version " + component.getModuleVersion().getVersion() + " is not compatible with org.scala-sbt:zinc_" + DEFAULT_SCALA_ZINC_VERSION + ":" + DEFAULT_ZINC_VERSION);
                }
            }));
        });
        zinc.getDependencyConstraints().add(dependencyHandler.getConstraints().create("org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject("[2.0, 2.17.1)");
        })));
        Configuration incrementalAnalysisElements = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisElements");
        incrementalAnalysisElements.setVisible(false);
        incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
        incrementalAnalysisElements.setCanBeResolved(false);
        incrementalAnalysisElements.setCanBeConsumed(true);
        incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
        AttributeMatchingStrategy<Usage> matchingStrategy = dependencyHandler.getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, actionConfiguration -> {
            actionConfiguration.params(incrementalAnalysisUsage);
            actionConfiguration.params(this.objectFactory.named(Usage.class, "java-api"));
            actionConfiguration.params(this.objectFactory.named(Usage.class, "java-runtime"));
        });
    }

    private void configureSourceSetDefaults(final Project project, final Usage incrementalAnalysisUsage, final ObjectFactory objectFactory, final ScalaRuntime scalaRuntime) {
        project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = new DefaultScalaSourceSet(displayName, objectFactory);
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                sourceSet.getExtensions().add(ScalaSourceDirectorySet.class, "scala", scalaSourceSet.getScala());
                ScalaSourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir(project.file("src/" + sourceSet.getName() + "/scala"));
                sourceSet.getAllJava().source(scalaDirectorySet);
                sourceSet.getAllSource().source(scalaDirectorySet);
                ScalaSourceDirectorySet scalaSource = scalaDirectorySet;
                sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(element -> scalaSource.contains(element.getFile())));
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration incrementalAnalysis = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisFor" + sourceSet.getName());
                incrementalAnalysis.setVisible(false);
                incrementalAnalysis.setDescription("Incremental compilation analysis files for " + displayName);
                incrementalAnalysis.setCanBeResolved(true);
                incrementalAnalysis.setCanBeConsumed(false);
                incrementalAnalysis.extendsFrom(classpath);
                incrementalAnalysis.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
                ScalaBasePlugin.this.configureScalaCompile(project, sourceSet, incrementalAnalysis, incrementalAnalysisUsage, scalaRuntime);
            }
        });
    }

    private void configureScalaCompile(Project project, SourceSet sourceSet, Configuration incrementalAnalysis, Usage incrementalAnalysisUsage, ScalaRuntime scalaRuntime) {
        ScalaSourceDirectorySet scalaSourceSet = sourceSet.getExtensions().getByType(ScalaSourceDirectorySet.class);
        NamedDomainObjectProvider scalaCompileTask = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, scalaCompile -> {
            JvmPluginsHelper.configureForSourceSet(sourceSet, scalaSourceSet, scalaCompile, scalaCompile.getOptions(), project);
            scalaCompile.setDescription("Compiles the " + scalaSourceSet + ".");
            scalaCompile.setSource(scalaSourceSet);
            scalaCompile.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor));
            scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
            IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
            incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
            incrementalOptions.getClassfileBackupDir().set(project.getLayout().getBuildDirectory().file("tmp/scala/classfileBackup/" + scalaCompile.getName() + ".bak"));
            Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
            if (jarTask != null) {
                incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
            }
            scalaCompile.getAnalysisFiles().from(incrementalAnalysis.getIncoming().artifactView((Action<? super ArtifactView.ViewConfiguration>)new Action<ArtifactView.ViewConfiguration>(){

                @Override
                public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                    viewConfiguration.lenient(true);
                    viewConfiguration.componentFilter(new IsProjectComponent());
                }
            }).getFiles());
            scalaCompile.dependsOn(scalaCompile.getAnalysisFiles());
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, (SourceDirectorySet)scalaSourceSet, project, (TaskProvider<? extends AbstractCompile>)scalaCompileTask, scalaCompileTask.map(new Transformer<CompileOptions, ScalaCompile>(){

            @Override
            public CompileOptions transform(ScalaCompile scalaCompile) {
                return scalaCompile.getOptions();
            }
        }));
        project.getTasks().named(sourceSet.getClassesTaskName(), new Action<Task>((TaskProvider)scalaCompileTask){
            final /* synthetic */ TaskProvider val$scalaCompileTask;
            {
                this.val$scalaCompileTask = taskProvider;
            }

            @Override
            public void execute(Task task) {
                task.dependsOn(this.val$scalaCompileTask);
            }
        });
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper) {
        JavaPluginExtension extension = this.extensionOf(project, JavaPluginExtension.class);
        JavaToolchainService service = this.extensionOf(project, JavaToolchainService.class);
        return toolMapper.apply(service, extension.getToolchain());
    }

    private static void configureCompileDefaults(Project project, ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaCompile.class).configureEach(compile -> {
            compile.getConventionMapping().map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath(compile.getClasspath()));
            compile.getConventionMapping().map("zincClasspath", () -> project.getConfigurations().getAt(ZINC_CONFIGURATION_NAME));
            compile.getConventionMapping().map(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME, () -> project.getConfigurations().getAt(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME));
        });
    }

    private void configureScaladoc(Project project, ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("destinationDir", () -> project.getExtensions().getByType(JavaPluginExtension.class).getDocsDir().dir("scaladoc").get().getAsFile());
            scalaDoc.getConventionMapping().map("title", () -> project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle());
            scalaDoc.getConventionMapping().map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath(scalaDoc.getClasspath()));
            scalaDoc.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor));
        });
    }

    private <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return extensionAware.getExtensions().getByType(type);
    }

    private static class IsProjectComponent
    implements Spec<ComponentIdentifier> {
        private IsProjectComponent() {
        }

        @Override
        public boolean isSatisfiedBy(ComponentIdentifier element) {
            return element instanceof ProjectComponentIdentifier;
        }
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntime;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntime) {
            this.javaRuntime = javaRuntime;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntime);
        }

        @Override
        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch(this.javaRuntime);
            }
        }
    }
}

