/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.MinimalGroovyCompileOptions;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.GroovyRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.IncubationLogger;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class GroovyCompile
extends AbstractCompile
implements HasCompileOptions {
    private FileCollection groovyClasspath;
    private final ConfigurableFileCollection astTransformationClasspath;
    private final CompileOptions compileOptions;
    private final GroovyCompileOptions groovyCompileOptions = this.getProject().getObjects().newInstance(GroovyCompileOptions.class, new Object[0]);
    private final FileCollection stableSources = this.getProject().files(this::getSource);
    private final Property<JavaLauncher> javaLauncher;
    private File previousCompilationDataFile;

    public GroovyCompile() {
        ObjectFactory objectFactory = this.getObjectFactory();
        CompileOptions compileOptions = objectFactory.newInstance(CompileOptions.class, new Object[0]);
        compileOptions.setIncremental(false);
        this.compileOptions = compileOptions;
        this.javaLauncher = objectFactory.property(JavaLauncher.class);
        this.astTransformationClasspath = objectFactory.fileCollection();
        if (!this.experimentalCompilationAvoidanceEnabled()) {
            this.astTransformationClasspath.from(this::getClasspath);
        }
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, this.getOutputs());
    }

    @Override
    @CompileClasspath
    @Incremental
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Classpath
    public ConfigurableFileCollection getAstTransformationClasspath() {
        return this.astTransformationClasspath;
    }

    private boolean experimentalCompilationAvoidanceEnabled() {
        return this.getFeaturePreviews().isFeatureEnabled(FeaturePreviews.Feature.GROOVY_COMPILATION_AVOIDANCE);
    }

    @TaskAction
    protected void compile(InputChanges inputChanges) {
        this.checkGroovyClasspathIsNonEmpty();
        this.warnIfCompileAvoidanceEnabled();
        GroovyJavaJointCompileSpec spec = this.createSpec();
        WorkResult result2 = this.getCompiler(spec, inputChanges).execute(spec);
        this.setDidWork(result2.getDidWork());
    }

    @OutputFile
    protected File getPreviousCompilationData() {
        if (this.previousCompilationDataFile == null) {
            this.previousCompilationDataFile = new File(this.getTemporaryDirWithoutCreating(), "previous-compilation-data.bin");
        }
        return this.previousCompilationDataFile;
    }

    private void warnIfCompileAvoidanceEnabled() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            IncubationLogger.incubatingFeatureUsed("Groovy compilation avoidance");
        }
    }

    private Compiler<GroovyJavaJointCompileSpec> getCompiler(GroovyJavaJointCompileSpec spec, InputChanges inputChanges) {
        GroovyCompilerFactory groovyCompilerFactory = this.getGroovyCompilerFactory();
        Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
        CleaningJavaCompiler<GroovyJavaJointCompileSpec> cleaningGroovyCompiler = new CleaningJavaCompiler<GroovyJavaJointCompileSpec>(delegatingCompiler, this.getOutputs(), this.getDeleter());
        if (spec.incrementalCompilationEnabled()) {
            IncrementalCompilerFactory factory = this.getIncrementalCompilerFactory();
            return factory.makeIncremental(cleaningGroovyCompiler, this.getStableSources().getAsFileTree(), this.createRecompilationSpecProvider(inputChanges));
        }
        return cleaningGroovyCompiler;
    }

    @Inject
    protected GroovyCompilerFactory getGroovyCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    private RecompilationSpecProvider createRecompilationSpecProvider(InputChanges inputChanges) {
        FileCollection stableSources = this.getStableSources();
        return new GroovyRecompilationSpecProvider(this.getDeleter(), this.getServices().get(FileOperations.class), stableSources.getAsFileTree(), inputChanges.isIncremental(), () -> inputChanges.getFileChanges(stableSources).iterator());
    }

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    private FileCollection determineGroovyCompileClasspath() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            return this.astTransformationClasspath.plus(this.getClasspath());
        }
        return this.getClasspath();
    }

    private static void validateIncrementalCompilationOptions(List<File> sourceRoots, boolean annotationProcessingConfigured) {
        if (sourceRoots.isEmpty()) {
            throw new InvalidUserDataException("Unable to infer source roots. Incremental Groovy compilation requires the source roots. Change the configuration of your sources or disable incremental Groovy compilation.");
        }
        if (annotationProcessingConfigured) {
            throw new InvalidUserDataException("Enabling incremental compilation and configuring Java annotation processors for Groovy compilation is not allowed. Disable incremental Groovy compilation or remove the Java annotation processor configuration.");
        }
    }

    @Nullable
    private JavaInstallationMetadata getToolchain() {
        return this.javaLauncher.map(JavaLauncher::getMetadata).getOrNull();
    }

    private GroovyJavaJointCompileSpec createSpec() {
        this.validateConfiguration();
        DefaultGroovyJavaJointCompileSpec spec = (DefaultGroovyJavaJointCompileSpec)new DefaultGroovyJavaJointCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
        assert (spec != null);
        FileTreeInternal stableSourcesAsFileTree = (FileTreeInternal)this.getStableSources().getAsFileTree();
        List<File> sourceRoots = CompilationSourceDirs.inferSourceRoots(stableSourcesAsFileTree);
        spec.setSourcesRoots(sourceRoots);
        spec.setSourceFiles(stableSourcesAsFileTree);
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)this.determineGroovyCompileClasspath()));
        this.configureCompatibilityOptions(spec);
        spec.setAnnotationProcessorPath(Lists.newArrayList((Iterable)(this.compileOptions.getAnnotationProcessorPath() == null ? this.getProjectLayout().files(new Object[0]) : this.compileOptions.getAnnotationProcessorPath())));
        spec.setGroovyClasspath(Lists.newArrayList((Iterable)this.getGroovyClasspath()));
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(new MinimalGroovyCompileOptions(this.groovyCompileOptions));
        spec.getCompileOptions().setSupportsCompilerApi(true);
        if (this.getOptions().isIncremental()) {
            GroovyCompile.validateIncrementalCompilationOptions(sourceRoots, spec.annotationProcessingConfigured());
            spec.getCompileOptions().setPreviousCompilationDataFile(this.getPreviousCompilationData());
        }
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs(dir);
            spec.getGroovyCompileOptions().setStubDir(dir);
        }
        this.configureExecutable(spec.getCompileOptions().getForkOptions());
        return spec;
    }

    private void configureCompatibilityOptions(DefaultGroovyJavaJointCompileSpec spec) {
        JavaInstallationMetadata toolchain = this.getToolchain();
        if (toolchain != null) {
            boolean isSourceOrTargetConfigured = false;
            if (super.getSourceCompatibility() != null) {
                spec.setSourceCompatibility(this.getSourceCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (super.getTargetCompatibility() != null) {
                spec.setTargetCompatibility(this.getTargetCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (!isSourceOrTargetConfigured) {
                String languageVersion = toolchain.getLanguageVersion().toString();
                spec.setSourceCompatibility(languageVersion);
                spec.setTargetCompatibility(languageVersion);
            }
        } else {
            spec.setSourceCompatibility(this.getSourceCompatibility());
            spec.setTargetCompatibility(this.getTargetCompatibility());
        }
    }

    private void configureExecutable(MinimalJavaCompilerDaemonForkOptions forkOptions) {
        if (this.javaLauncher.isPresent()) {
            forkOptions.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        } else {
            forkOptions.setExecutable(Jvm.current().getJavaExecutable().getAbsolutePath());
        }
    }

    private void validateConfiguration() {
        if (this.javaLauncher.isPresent()) {
            Preconditions.checkState((this.getOptions().getForkOptions().getJavaHome() == null ? 1 : 0) != 0, (Object)"Must not use `javaHome` property on `ForkOptions` together with `javaLauncher` property");
            Preconditions.checkState((this.getOptions().getForkOptions().getExecutable() == null ? 1 : 0) != 0, (Object)"Must not use `executable` property on `ForkOptions` together with `javaLauncher` property");
        }
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @Input
    protected String getGroovyCompilerJvmVersion() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().toString();
        }
        File customHome = this.getOptions().getForkOptions().getJavaHome();
        if (customHome != null) {
            return this.getServices().get(JvmMetadataDetector.class).getMetadata(customHome).getLanguageVersion().getMajorVersion();
        }
        return JavaVersion.current().getMajorVersion();
    }

    @Override
    @Internal(value="tracked via stableSources")
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Override
    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Classpath
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Nested
    @Optional
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @Inject
    protected FeaturePreviews getFeaturePreviews() {
        throw new UnsupportedOperationException();
    }

    private File getTemporaryDirWithoutCreating() {
        return this.getServices().get(TemporaryFileProvider.class).newTemporaryFile(this.getName());
    }
}

