/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioProjectFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.internal.VersionNumber;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public class GenerateProjectFileTask
extends XmlGeneratorTask<VisualStudioProjectFile> {
    private DefaultVisualStudioProject visualStudioProject;
    private String gradleExe;
    private String gradleArgs;

    @Override
    protected boolean getIncremental() {
        return true;
    }

    public void initGradleCommand() {
        final File gradlew = new File(IdePlugin.toGradleCommand(this.getProject()));
        this.getConventionMapping().map("gradleExe", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String rootDir = GenerateProjectFileTask.this.getTransformer().transform(GenerateProjectFileTask.this.getProject().getRootDir());
                String args = "";
                if (!rootDir.equals(".")) {
                    args = " -p \"" + rootDir + "\"";
                }
                if (gradlew.isFile()) {
                    return "\"" + GenerateProjectFileTask.this.getTransformer().transform(gradlew) + "\"" + args;
                }
                return "\"gradle\"" + args;
            }
        });
    }

    @Internal
    public Transformer<String, File> getTransformer() {
        return RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getProjectFile().getLocation());
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Nested
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    @Override
    @Internal
    public File getInputFile() {
        return null;
    }

    @Override
    @OutputFile
    public File getOutputFile() {
        return this.visualStudioProject.getProjectFile().getLocation();
    }

    @Override
    protected VisualStudioProjectFile create() {
        return new VisualStudioProjectFile(this.getXmlTransformer(), this.getTransformer());
    }

    @Override
    protected void configure(VisualStudioProjectFile projectFile) {
        DefaultVisualStudioProject vsProject = this.visualStudioProject;
        projectFile.setGradleCommand(this.buildGradleCommand());
        projectFile.setProjectUuid(DefaultVisualStudioProject.getUUID(this.getOutputFile()));
        projectFile.setVisualStudioVersion((VersionNumber)this.visualStudioProject.getVisualStudioVersion().get());
        projectFile.setSdkVersion((VersionNumber)this.visualStudioProject.getSdkVersion().get());
        for (File file : vsProject.getSourceFiles()) {
            projectFile.addSourceFile(file);
        }
        for (File file : vsProject.getResourceFiles()) {
            projectFile.addResource(file);
        }
        for (File file : vsProject.getHeaderFiles()) {
            projectFile.addHeaderFile(file);
        }
        if (vsProject.getConfigurations().stream().noneMatch(it -> it.isBuildable())) {
            this.getLogger().warn("'" + vsProject.getComponentName() + "' component in project '" + this.getProject().getPath() + "' is not buildable.");
        }
        for (VisualStudioProjectConfiguration visualStudioProjectConfiguration : vsProject.getConfigurations()) {
            projectFile.addConfiguration(visualStudioProjectConfiguration);
        }
        for (Action action : vsProject.getProjectFile().getXmlActions()) {
            this.getXmlTransformer().addAction(action);
        }
    }

    private String buildGradleCommand() {
        String exe = this.getGradleExe();
        String args = this.getGradleArgs();
        if (args == null || args.trim().length() == 0) {
            return exe;
        }
        return exe + " " + args.trim();
    }

    @Input
    public String getGradleExe() {
        return this.gradleExe;
    }

    public void setGradleExe(String gradleExe) {
        this.gradleExe = gradleExe;
    }

    @Nullable
    @Optional
    @Input
    public String getGradleArgs() {
        return this.gradleArgs;
    }

    public void setGradleArgs(@Nullable String gradleArgs) {
        this.gradleArgs = gradleArgs;
    }
}

