/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newLinkedHashMap();
    private final Multimap<String, LocalComponentArtifactMetadata> allArtifacts = ArrayListMultimap.create();
    private final SetMultimap<String, DefaultVariantMetadata> allVariants = LinkedHashMultimap.create();
    private final ComponentIdentifier componentId;
    private final ModuleVersionIdentifier moduleVersionId;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleSources moduleSources = ImmutableModuleSources.of();
    private Optional<ImmutableList<? extends ConfigurationMetadata>> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier moduleVersionId, ComponentIdentifier componentId, String status, AttributesSchemaInternal attributesSchema) {
        this.moduleVersionId = moduleVersionId;
        this.componentId = componentId;
        this.status = status;
        this.attributesSchema = attributesSchema;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts2) {
        DefaultLocalComponentMetadata copy = new DefaultLocalComponentMetadata(this.moduleVersionId, componentIdentifier, this.status, this.attributesSchema);
        for (DefaultLocalConfigurationMetadata configuration2 : this.allConfigurations.values()) {
            copy.addConfiguration(configuration2.getName(), configuration2.description, configuration2.extendsFrom, (ImmutableSet<String>)configuration2.hierarchy, configuration2.visible, configuration2.transitive, configuration2.attributes, configuration2.canBeConsumed, configuration2.consumptionDeprecation, configuration2.canBeResolved, configuration2.capabilities, Collections::emptyList);
        }
        HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts = new HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>();
        for (Map.Entry entry : this.allArtifacts.entries()) {
            LocalComponentArtifactMetadata oldArtifact = (LocalComponentArtifactMetadata)entry.getValue();
            LocalComponentArtifactMetadata newArtifact = this.copyArtifact(oldArtifact, artifacts2, transformedArtifacts);
            copy.allArtifacts.put((Object)((String)entry.getKey()), (Object)newArtifact);
        }
        for (Map.Entry entry : this.allVariants.entries()) {
            DefaultVariantMetadata oldVariant = (DefaultVariantMetadata)entry.getValue();
            ImmutableList.Builder newArtifacts = new ImmutableList.Builder();
            for (ComponentArtifactMetadata oldArtifact : oldVariant.getArtifacts()) {
                newArtifacts.add((Object)this.copyArtifact((LocalComponentArtifactMetadata)oldArtifact, artifacts2, transformedArtifacts));
            }
            copy.allVariants.put((Object)((String)entry.getKey()), (Object)new DefaultVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), (ImmutableList<? extends ComponentArtifactMetadata>)newArtifacts.build(), oldVariant.getCapabilities()));
        }
        for (DefaultLocalConfigurationMetadata configuration3 : this.allConfigurations.values()) {
            configuration3.realizeDependencies();
            DefaultLocalConfigurationMetadata configurationCopy = copy.allConfigurations.get(configuration3.getName());
            configurationCopy.definedDependencies.addAll(configuration3.definedDependencies);
            configurationCopy.definedFiles.addAll(configuration3.definedFiles);
            configurationCopy.definedExcludes.addAll(configuration3.definedExcludes);
        }
        return copy;
    }

    private LocalComponentArtifactMetadata copyArtifact(LocalComponentArtifactMetadata oldArtifact, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        LocalComponentArtifactMetadata newArtifact = transformedArtifacts.get(oldArtifact);
        if (newArtifact == null) {
            newArtifact = transformer.transform(oldArtifact);
            transformedArtifacts.put(oldArtifact, newArtifact);
        }
        return newArtifact;
    }

    @Override
    public void addArtifacts(String configuration2, Collection<? extends PublishArtifact> artifacts2) {
        for (PublishArtifact publishArtifact : artifacts2) {
            PublishArtifactLocalArtifactMetadata artifactMetadata = new PublishArtifactLocalArtifactMetadata(this.componentId, publishArtifact);
            this.allArtifacts.put((Object)configuration2, (Object)artifactMetadata);
        }
    }

    @Override
    public void addVariant(String configuration2, String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, Collection<? extends PublishArtifact> publishArtifacts) {
        ImmutableList artifacts2;
        if (publishArtifacts.isEmpty()) {
            ImmutableList artifacts22 = ImmutableList.of();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (PublishArtifact publishArtifact : publishArtifacts) {
                builder.add((Object)new PublishArtifactLocalArtifactMetadata(this.componentId, publishArtifact));
            }
            artifacts2 = builder.build();
        }
        this.allVariants.put((Object)configuration2, (Object)new DefaultVariantMetadata(name, identifier, displayName, attributes, (ImmutableList<? extends ComponentArtifactMetadata>)artifacts2, capabilities));
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
        assert (hierarchy.contains((Object)name));
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities);
        this.addToConfigurations(name, conf);
        return conf;
    }

    protected void addToConfigurations(String name, DefaultLocalConfigurationMetadata conf) {
        this.allConfigurations.put(name, conf);
    }

    @Override
    public void addDependenciesAndExcludesForConfiguration(ConfigurationInternal configuration2, LocalConfigurationMetadataBuilder localConfigurationMetadataBuilder) {
        DefaultLocalConfigurationMetadata configurationMetadata = this.allConfigurations.get(configuration2.getName());
        configurationMetadata.configurationMetadataBuilder = localConfigurationMetadataBuilder;
        configurationMetadata.backingConfiguration = configuration2;
    }

    public String toString() {
        return this.componentId.getDisplayName();
    }

    @Override
    public ModuleSources getSources() {
        return this.moduleSources;
    }

    @Override
    public ComponentResolveMetadata withSources(ModuleSources source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public synchronized Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean hasAtLeastOneConsumableConfiguration = false;
            for (DefaultLocalConfigurationMetadata configuration2 : this.allConfigurations.values()) {
                if (!configuration2.isCanBeConsumed() || configuration2.getAttributes().isEmpty()) continue;
                hasAtLeastOneConsumableConfiguration = true;
                builder.add((Object)configuration2);
            }
            this.consumableConfigurations = hasAtLeastOneConsumableConfiguration ? Optional.of((Object)builder.build()) : Optional.absent();
        }
        return this.consumableConfigurations;
    }

    @Override
    public DefaultLocalConfigurationMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    protected class DefaultLocalConfigurationMetadata
    implements LocalConfigurationMetadata,
    BuildableLocalConfigurationMetadata {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final ImmutableSet<String> hierarchy;
        private final Set<String> extendsFrom;
        private final ImmutableAttributes attributes;
        private final boolean canBeConsumed;
        private final DeprecationMessageBuilder.WithDocumentation consumptionDeprecation;
        private final boolean canBeResolved;
        private final ImmutableCapabilities capabilities;
        private ConfigurationInternal backingConfiguration;
        private LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private final List<LocalOriginDependencyMetadata> definedDependencies = Lists.newArrayList();
        private final List<ExcludeMetadata> definedExcludes = Lists.newArrayList();
        private final List<LocalFileDependencyMetadata> definedFiles = Lists.newArrayList();
        private ImmutableList<LocalOriginDependencyMetadata> configurationDependencies;
        private ImmutableSet<LocalFileDependencyMetadata> configurationFileDependencies;
        private ImmutableList<ExcludeMetadata> configurationExcludes;
        private ImmutableList<LocalComponentArtifactMetadata> configurationArtifacts;

        protected DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.attributes = attributes;
            this.canBeConsumed = canBeConsumed;
            this.consumptionDeprecation = consumptionDeprecation;
            this.canBeResolved = canBeResolved;
            this.capabilities = capabilities;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return DefaultLocalComponentMetadata.this.componentId;
        }

        @Override
        public void addDependency(LocalOriginDependencyMetadata dependency) {
            this.definedDependencies.add(dependency);
        }

        @Override
        public void addExclude(ExcludeMetadata exclude) {
            this.definedExcludes.add(exclude);
        }

        @Override
        public void addFiles(LocalFileDependencyMetadata files) {
            this.definedFiles.add(files);
        }

        @Override
        public void enableLocking() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of(DefaultLocalComponentMetadata.this.componentId, "configuration", this.name);
        }

        public ComponentResolveMetadata getComponent() {
            return DefaultLocalComponentMetadata.this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImmutableSet<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getVariants() {
            return DefaultLocalComponentMetadata.this.allVariants.get((Object)this.name);
        }

        @Override
        public boolean isCanBeConsumed() {
            return this.canBeConsumed;
        }

        @Override
        public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
            return this.consumptionDeprecation;
        }

        @Override
        public boolean isCanBeResolved() {
            return this.canBeResolved;
        }

        @Override
        public List<? extends LocalOriginDependencyMetadata> getDependencies() {
            if (this.configurationDependencies == null) {
                ImmutableList.Builder result2 = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration2 : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration2)) continue;
                    configuration2.addDefinedDependencies((ImmutableList.Builder<LocalOriginDependencyMetadata>)result2);
                }
                AttributeValue<Category> attributeValue = this.getAttributes().findEntry(Category.CATEGORY_ATTRIBUTE);
                if (attributeValue.isPresent() && attributeValue.get().getName().equals("enforced-platform")) {
                    ImmutableList rawDependencies = result2.build();
                    result2 = ImmutableList.builder();
                    for (LocalOriginDependencyMetadata rawDependency : rawDependencies) {
                        result2.add((Object)rawDependency.forced());
                    }
                }
                this.configurationDependencies = result2.build();
            }
            return this.configurationDependencies;
        }

        List<LocalOriginDependencyMetadata> getSyntheticDependencies() {
            return Collections.emptyList();
        }

        void addDefinedDependencies(ImmutableList.Builder<LocalOriginDependencyMetadata> result2) {
            this.realizeDependencies();
            result2.addAll(this.definedDependencies);
        }

        @Override
        public Set<LocalFileDependencyMetadata> getFiles() {
            if (this.configurationFileDependencies == null) {
                ImmutableSet.Builder result2 = ImmutableSet.builder();
                for (DefaultLocalConfigurationMetadata configuration2 : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration2)) continue;
                    configuration2.addDefinedFiles((ImmutableSet.Builder<LocalFileDependencyMetadata>)result2);
                }
                this.configurationFileDependencies = result2.build();
            }
            return this.configurationFileDependencies;
        }

        void addDefinedFiles(ImmutableSet.Builder<LocalFileDependencyMetadata> result2) {
            this.realizeDependencies();
            result2.addAll(this.definedFiles);
        }

        @Override
        public ImmutableList<ExcludeMetadata> getExcludes() {
            if (this.configurationExcludes == null) {
                ImmutableList.Builder result2 = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration2 : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration2)) continue;
                    configuration2.addDefinedExcludes((ImmutableList.Builder<ExcludeMetadata>)result2);
                }
                this.configurationExcludes = result2.build();
            }
            return this.configurationExcludes;
        }

        void addDefinedExcludes(ImmutableList.Builder<ExcludeMetadata> result2) {
            this.realizeDependencies();
            result2.addAll(this.definedExcludes);
        }

        @Override
        public ImmutableList<? extends LocalComponentArtifactMetadata> getArtifacts() {
            if (this.configurationArtifacts == null) {
                if (DefaultLocalComponentMetadata.this.allArtifacts.isEmpty()) {
                    this.configurationArtifacts = ImmutableList.of();
                } else {
                    ImmutableList.Builder result2 = ImmutableList.builder();
                    for (String config : this.hierarchy) {
                        result2.addAll((Iterable)DefaultLocalComponentMetadata.this.allArtifacts.get((Object)config));
                    }
                    this.configurationArtifacts = result2.build();
                }
            }
            return this.configurationArtifacts;
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
                if (!candidate.getName().equals(ivyArtifactName)) continue;
                return candidate;
            }
            return new MissingLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentId, ivyArtifactName);
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.capabilities;
        }

        @Override
        public boolean requiresMavenArtifactDiscovery() {
            return false;
        }

        @Override
        public boolean isExternalVariant() {
            return false;
        }

        private boolean include(DefaultLocalConfigurationMetadata configuration2) {
            return this.hierarchy.contains((Object)configuration2.getName());
        }

        synchronized void realizeDependencies() {
            if (this.backingConfiguration != null) {
                this.backingConfiguration.runDependencyActions();
                this.configurationMetadataBuilder.addDependenciesAndExcludes(this, this.backingConfiguration);
                this.backingConfiguration = null;
            }
        }
    }
}

